@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.DirectLineChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Direct Line channel.
 * @property directLineEmbedCode Direct Line embed code of the resource
 * @property extensionKey1 The extensionKey1
 * @property extensionKey2 The extensionKey2
 * @property sites The list of Direct Line sites
 */
public data class DirectLineChannelPropertiesArgs(
    public val directLineEmbedCode: Output<String>? = null,
    public val extensionKey1: Output<String>? = null,
    public val extensionKey2: Output<String>? = null,
    public val sites: Output<List<DirectLineSiteArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.DirectLineChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.DirectLineChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.DirectLineChannelPropertiesArgs.builder()
            .directLineEmbedCode(directLineEmbedCode?.applyValue({ args0 -> args0 }))
            .extensionKey1(extensionKey1?.applyValue({ args0 -> args0 }))
            .extensionKey2(extensionKey2?.applyValue({ args0 -> args0 }))
            .sites(
                sites?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DirectLineChannelPropertiesArgs].
 */
@PulumiTagMarker
public class DirectLineChannelPropertiesArgsBuilder internal constructor() {
    private var directLineEmbedCode: Output<String>? = null

    private var extensionKey1: Output<String>? = null

    private var extensionKey2: Output<String>? = null

    private var sites: Output<List<DirectLineSiteArgs>>? = null

    /**
     * @param value Direct Line embed code of the resource
     */
    @JvmName("nehrpfrlcoyvopaw")
    public suspend fun directLineEmbedCode(`value`: Output<String>) {
        this.directLineEmbedCode = value
    }

    /**
     * @param value The extensionKey1
     */
    @JvmName("fyhpvcrvmvldljxy")
    public suspend fun extensionKey1(`value`: Output<String>) {
        this.extensionKey1 = value
    }

    /**
     * @param value The extensionKey2
     */
    @JvmName("ayrbdfecvjjshxss")
    public suspend fun extensionKey2(`value`: Output<String>) {
        this.extensionKey2 = value
    }

    /**
     * @param value The list of Direct Line sites
     */
    @JvmName("ptaaeesxkclodyav")
    public suspend fun sites(`value`: Output<List<DirectLineSiteArgs>>) {
        this.sites = value
    }

    @JvmName("sirsrigefnkqhgjt")
    public suspend fun sites(vararg values: Output<DirectLineSiteArgs>) {
        this.sites = Output.all(values.asList())
    }

    /**
     * @param values The list of Direct Line sites
     */
    @JvmName("rtgveivmrqkoakon")
    public suspend fun sites(values: List<Output<DirectLineSiteArgs>>) {
        this.sites = Output.all(values)
    }

    /**
     * @param value Direct Line embed code of the resource
     */
    @JvmName("kvyljewqtqbwvvgu")
    public suspend fun directLineEmbedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directLineEmbedCode = mapped
    }

    /**
     * @param value The extensionKey1
     */
    @JvmName("fshokywcidsjpxrs")
    public suspend fun extensionKey1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionKey1 = mapped
    }

    /**
     * @param value The extensionKey2
     */
    @JvmName("cwpnkwmsdiqlfjke")
    public suspend fun extensionKey2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionKey2 = mapped
    }

    /**
     * @param value The list of Direct Line sites
     */
    @JvmName("lrsawdmalqyeeknw")
    public suspend fun sites(`value`: List<DirectLineSiteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    /**
     * @param argument The list of Direct Line sites
     */
    @JvmName("ahtmyjdddosumuuk")
    public suspend fun sites(argument: List<suspend DirectLineSiteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DirectLineSiteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param argument The list of Direct Line sites
     */
    @JvmName("xexvoukrmjimaofb")
    public suspend fun sites(vararg argument: suspend DirectLineSiteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DirectLineSiteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param argument The list of Direct Line sites
     */
    @JvmName("kgqfsfbonlfgiapw")
    public suspend fun sites(argument: suspend DirectLineSiteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DirectLineSiteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param values The list of Direct Line sites
     */
    @JvmName("kjqnjdluuoldxkue")
    public suspend fun sites(vararg values: DirectLineSiteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    internal fun build(): DirectLineChannelPropertiesArgs = DirectLineChannelPropertiesArgs(
        directLineEmbedCode = directLineEmbedCode,
        extensionKey1 = extensionKey1,
        extensionKey2 = extensionKey2,
        sites = sites,
    )
}
