@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.FacebookPageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Facebook page for Facebook channel registration
 * @property accessToken Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property id Page id
 */
public data class FacebookPageArgs(
    public val accessToken: Output<String>? = null,
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.FacebookPageArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.FacebookPageArgs =
        com.pulumi.azurenative.botservice.inputs.FacebookPageArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FacebookPageArgs].
 */
@PulumiTagMarker
public class FacebookPageArgsBuilder internal constructor() {
    private var accessToken: Output<String>? = null

    private var id: Output<String>? = null

    /**
     * @param value Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("svsklqliojfacvtb")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value Page id
     */
    @JvmName("bxivdxqyhebfppvh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("omimydsxojqijqgs")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Page id
     */
    @JvmName("cyedykxnjbxmldfb")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): FacebookPageArgs = FacebookPageArgs(
        accessToken = accessToken,
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
