@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.GetChannelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property channelName The name of the Bot resource.
 * @property resourceGroupName The name of the Bot resource group in the user subscription.
 * @property resourceName The name of the Bot resource.
 */
public data class GetChannelPlainArgs(
    public val channelName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.GetChannelPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.GetChannelPlainArgs =
        com.pulumi.azurenative.botservice.inputs.GetChannelPlainArgs.builder()
            .channelName(channelName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetChannelPlainArgs].
 */
@PulumiTagMarker
public class GetChannelPlainArgsBuilder internal constructor() {
    private var channelName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("fcktjewydplvrkxl")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.channelName = mapped
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("rtqgcgkjascieakj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("vdbiyipegvxrneur")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetChannelPlainArgs = GetChannelPlainArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
