@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.M365ExtensionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * M365 Extensions definition
 * @property channelName The channel name
 * Expected value is 'M365Extensions'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 */
public data class M365ExtensionsArgs(
    public val channelName: Output<String>,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.M365ExtensionsArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.M365ExtensionsArgs =
        com.pulumi.azurenative.botservice.inputs.M365ExtensionsArgs.builder()
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [M365ExtensionsArgs].
 */
@PulumiTagMarker
public class M365ExtensionsArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    /**
     * @param value The channel name
     * Expected value is 'M365Extensions'.
     */
    @JvmName("xfulvpgfhtwadiub")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("nyrcxubfoqtvarrw")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("erpeansfxalsrylh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The channel name
     * Expected value is 'M365Extensions'.
     */
    @JvmName("suarvpecltrnjfys")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("ciixmowmpccrbtxb")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("mykncbqdxuwchmoc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    internal fun build(): M365ExtensionsArgs = M365ExtensionsArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        etag = etag,
        location = location,
    )
}
