@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.SmsChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Sms channel.
 * @property accountSID The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property authToken The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property isValidated Whether this channel is validated for the bot
 * @property phone The Sms phone
 */
public data class SmsChannelPropertiesArgs(
    public val accountSID: Output<String>,
    public val authToken: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
    public val isValidated: Output<Boolean>? = null,
    public val phone: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.SmsChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.SmsChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.SmsChannelPropertiesArgs.builder()
            .accountSID(accountSID.applyValue({ args0 -> args0 }))
            .authToken(authToken?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .isValidated(isValidated?.applyValue({ args0 -> args0 }))
            .phone(phone.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmsChannelPropertiesArgs].
 */
@PulumiTagMarker
public class SmsChannelPropertiesArgsBuilder internal constructor() {
    private var accountSID: Output<String>? = null

    private var authToken: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var isValidated: Output<Boolean>? = null

    private var phone: Output<String>? = null

    /**
     * @param value The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("orxukqhnbyiijrte")
    public suspend fun accountSID(`value`: Output<String>) {
        this.accountSID = value
    }

    /**
     * @param value The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("dupunclbtfgjtiiy")
    public suspend fun authToken(`value`: Output<String>) {
        this.authToken = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("rmqjqofuhjpnkghi")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Whether this channel is validated for the bot
     */
    @JvmName("bxcindspyghepafo")
    public suspend fun isValidated(`value`: Output<Boolean>) {
        this.isValidated = value
    }

    /**
     * @param value The Sms phone
     */
    @JvmName("ifgnldkolhibjbbt")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("xnhbgewysnbufqcu")
    public suspend fun accountSID(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountSID = mapped
    }

    /**
     * @param value The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("biqihpfwthshrvui")
    public suspend fun authToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authToken = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("xcnaxjpgofkeemwe")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Whether this channel is validated for the bot
     */
    @JvmName("nwbgxnclffjymmtx")
    public suspend fun isValidated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isValidated = mapped
    }

    /**
     * @param value The Sms phone
     */
    @JvmName("kmnkyrkqekruupvg")
    public suspend fun phone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    internal fun build(): SmsChannelPropertiesArgs = SmsChannelPropertiesArgs(
        accountSID = accountSID ?: throw PulumiNullFieldException("accountSID"),
        authToken = authToken,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        isValidated = isValidated,
        phone = phone ?: throw PulumiNullFieldException("phone"),
    )
}
