@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.WebChatChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Web Chat channel definition
 * @property channelName The channel name
 * Expected value is 'WebChatChannel'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to Web Chat channel resource
 */
public data class WebChatChannelArgs(
    public val channelName: Output<String>,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<WebChatChannelPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.WebChatChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.WebChatChannelArgs =
        com.pulumi.azurenative.botservice.inputs.WebChatChannelArgs.builder()
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebChatChannelArgs].
 */
@PulumiTagMarker
public class WebChatChannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<WebChatChannelPropertiesArgs>? = null

    /**
     * @param value The channel name
     * Expected value is 'WebChatChannel'.
     */
    @JvmName("fderqhrcqcqwgnfm")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("etaiokahpcqtqyim")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("psbodeqpijuxdtee")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to Web Chat channel resource
     */
    @JvmName("rdksghglpofbdtet")
    public suspend fun properties(`value`: Output<WebChatChannelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The channel name
     * Expected value is 'WebChatChannel'.
     */
    @JvmName("ixvqfpbwugvlhyhg")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("ybvkjbxwebdilous")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("olnwsxowcpwcndwu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to Web Chat channel resource
     */
    @JvmName("osneqiuyopvyruft")
    public suspend fun properties(`value`: WebChatChannelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to Web Chat channel resource
     */
    @JvmName("aepmdonbgnycprdf")
    public suspend fun properties(argument: suspend WebChatChannelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WebChatChannelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): WebChatChannelArgs = WebChatChannelArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        etag = etag,
        location = location,
        properties = properties,
    )
}
