@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.WebChatChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Web Chat channel.
 * @property sites The list of Web Chat sites
 */
public data class WebChatChannelPropertiesArgs(
    public val sites: Output<List<WebChatSiteArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.WebChatChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.WebChatChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.WebChatChannelPropertiesArgs.builder()
            .sites(
                sites?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebChatChannelPropertiesArgs].
 */
@PulumiTagMarker
public class WebChatChannelPropertiesArgsBuilder internal constructor() {
    private var sites: Output<List<WebChatSiteArgs>>? = null

    /**
     * @param value The list of Web Chat sites
     */
    @JvmName("ayoqnwdxwdhxuidg")
    public suspend fun sites(`value`: Output<List<WebChatSiteArgs>>) {
        this.sites = value
    }

    @JvmName("klkdldyrwnphmeho")
    public suspend fun sites(vararg values: Output<WebChatSiteArgs>) {
        this.sites = Output.all(values.asList())
    }

    /**
     * @param values The list of Web Chat sites
     */
    @JvmName("emxeuashjmqhfvde")
    public suspend fun sites(values: List<Output<WebChatSiteArgs>>) {
        this.sites = Output.all(values)
    }

    /**
     * @param value The list of Web Chat sites
     */
    @JvmName("xlhokogmfaqmlqta")
    public suspend fun sites(`value`: List<WebChatSiteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    /**
     * @param argument The list of Web Chat sites
     */
    @JvmName("avjkttdcpjtbxrdb")
    public suspend fun sites(argument: List<suspend WebChatSiteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { WebChatSiteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param argument The list of Web Chat sites
     */
    @JvmName("kkxinqqpxetawufy")
    public suspend fun sites(vararg argument: suspend WebChatSiteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { WebChatSiteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param argument The list of Web Chat sites
     */
    @JvmName("dotsbhrvsydvmttx")
    public suspend fun sites(argument: suspend WebChatSiteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebChatSiteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param values The list of Web Chat sites
     */
    @JvmName("riesbugnwuvmdeip")
    public suspend fun sites(vararg values: WebChatSiteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    internal fun build(): WebChatChannelPropertiesArgs = WebChatChannelPropertiesArgs(
        sites = sites,
    )
}
