@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
 * @property key Key for the Connection Setting Parameter.
 * @property value Value associated with the Connection Setting Parameter.
 */
public data class ConnectionSettingParameterResponse(
    public val key: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ConnectionSettingParameterResponse):
            ConnectionSettingParameterResponse = ConnectionSettingParameterResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
