@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The parameters to provide for the Line channel.
 * @property callbackUrl Callback Url to enter in line registration.
 * @property isValidated Whether this channel is validated for the bot
 * @property lineRegistrations The list of line channel registrations
 */
public data class LineChannelPropertiesResponse(
    public val callbackUrl: String,
    public val isValidated: Boolean,
    public val lineRegistrations: List<LineRegistrationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.LineChannelPropertiesResponse):
            LineChannelPropertiesResponse = LineChannelPropertiesResponse(
            callbackUrl = javaType.callbackUrl(),
            isValidated = javaType.isValidated(),
            lineRegistrations = javaType.lineRegistrations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.LineRegistrationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
