@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Object used to describe a Service Provider supported by Bot Service
 * @property devPortalUrl URL of Dev Portal
 * @property displayName Display Name of the Service Provider
 * @property iconUrl The URL of icon
 * @property id Id for Service Provider
 * @property parameters The list of parameters for the Service Provider
 * @property serviceProviderName Name of the Service Provider
 */
public data class ServiceProviderPropertiesResponse(
    public val devPortalUrl: String,
    public val displayName: String,
    public val iconUrl: String? = null,
    public val id: String,
    public val parameters: List<ServiceProviderParameterResponse>? = null,
    public val serviceProviderName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ServiceProviderPropertiesResponse):
            ServiceProviderPropertiesResponse = ServiceProviderPropertiesResponse(
            devPortalUrl = javaType.devPortalUrl(),
            displayName = javaType.displayName(),
            iconUrl = javaType.iconUrl().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.ServiceProviderParameterResponse.Companion.toKotlin(args0)
                })
            }),
            serviceProviderName = javaType.serviceProviderName(),
        )
    }
}
