@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessPolicyAssignment].
 */
@PulumiTagMarker
public class AccessPolicyAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPolicyAssignmentArgs = AccessPolicyAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPolicyAssignmentArgsBuilder.() -> Unit) {
        val builder = AccessPolicyAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessPolicyAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.cache.AccessPolicyAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessPolicyAssignment(builtJavaResource)
    }
}

/**
 * Response to an operation on access policy assignment
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### RedisCacheAccessPolicyAssignmentCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessPolicyAssignment = new AzureNative.Cache.AccessPolicyAssignment("accessPolicyAssignment", new()
 *     {
 *         AccessPolicyAssignmentName = "accessPolicyAssignmentName1",
 *         AccessPolicyName = "accessPolicy1",
 *         CacheName = "cache1",
 *         ObjectId = "6497c918-11ad-41e7-1b0f-7c518a87d0b0",
 *         ObjectIdAlias = "TestAADAppRedis",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewAccessPolicyAssignment(ctx, "accessPolicyAssignment", &cache.AccessPolicyAssignmentArgs{
 * 			AccessPolicyAssignmentName: pulumi.String("accessPolicyAssignmentName1"),
 * 			AccessPolicyName:           pulumi.String("accessPolicy1"),
 * 			CacheName:                  pulumi.String("cache1"),
 * 			ObjectId:                   pulumi.String("6497c918-11ad-41e7-1b0f-7c518a87d0b0"),
 * 			ObjectIdAlias:              pulumi.String("TestAADAppRedis"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.AccessPolicyAssignment;
 * import com.pulumi.azurenative.cache.AccessPolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessPolicyAssignment = new AccessPolicyAssignment("accessPolicyAssignment", AccessPolicyAssignmentArgs.builder()
 *             .accessPolicyAssignmentName("accessPolicyAssignmentName1")
 *             .accessPolicyName("accessPolicy1")
 *             .cacheName("cache1")
 *             .objectId("6497c918-11ad-41e7-1b0f-7c518a87d0b0")
 *             .objectIdAlias("TestAADAppRedis")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:AccessPolicyAssignment accessPolicyAssignmentName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}
 * ```
 */
public class AccessPolicyAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.AccessPolicyAssignment,
) : KotlinCustomResource(javaResource, AccessPolicyAssignmentMapper) {
    /**
     * The name of the access policy that is being assigned
     */
    public val accessPolicyName: Output<String>
        get() = javaResource.accessPolicyName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Object Id to assign access policy to
     */
    public val objectId: Output<String>
        get() = javaResource.objectId().applyValue({ args0 -> args0 })

    /**
     * User friendly name for object id. Also represents username for token based authentication
     */
    public val objectIdAlias: Output<String>
        get() = javaResource.objectIdAlias().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of an access policy assignment set
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccessPolicyAssignmentMapper : ResourceMapper<AccessPolicyAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.AccessPolicyAssignment::class == javaResource::class

    override fun map(javaResource: Resource): AccessPolicyAssignment =
        AccessPolicyAssignment(javaResource as com.pulumi.azurenative.cache.AccessPolicyAssignment)
}

/**
 * @see [AccessPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPolicyAssignment].
 */
public suspend fun accessPolicyAssignment(
    name: String,
    block: suspend AccessPolicyAssignmentResourceBuilder.() -> Unit,
): AccessPolicyAssignment {
    val builder = AccessPolicyAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPolicyAssignment(name: String): AccessPolicyAssignment {
    val builder = AccessPolicyAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
