@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-05-01-preview, 2023-08-01.
 * ## Example Usage
 * ### RedisCacheFirewallRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.Cache.FirewallRule("firewallRule", new()
 *     {
 *         CacheName = "cache1",
 *         EndIP = "192.168.1.4",
 *         ResourceGroupName = "rg1",
 *         RuleName = "rule1",
 *         StartIP = "192.168.1.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewFirewallRule(ctx, "firewallRule", &cache.FirewallRuleArgs{
 * 			CacheName:         pulumi.String("cache1"),
 * 			EndIP:             pulumi.String("192.168.1.4"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RuleName:          pulumi.String("rule1"),
 * 			StartIP:           pulumi.String("192.168.1.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.FirewallRule;
 * import com.pulumi.azurenative.cache.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .cacheName("cache1")
 *             .endIP("192.168.1.4")
 *             .resourceGroupName("rg1")
 *             .ruleName("rule1")
 *             .startIP("192.168.1.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:FirewallRule cache1/rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/firewallRules/{ruleName}
 * ```
 * @property cacheName The name of the Redis cache.
 * @property endIP highest IP address included in the range
 * @property resourceGroupName The name of the resource group.
 * @property ruleName The name of the firewall rule.
 * @property startIP lowest IP address included in the range
 */
public data class FirewallRuleArgs(
    public val cacheName: Output<String>? = null,
    public val endIP: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val startIP: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.FirewallRuleArgs =
        com.pulumi.azurenative.cache.FirewallRuleArgs.builder()
            .cacheName(cacheName?.applyValue({ args0 -> args0 }))
            .endIP(endIP?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .startIP(startIP?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallRuleArgs].
 */
@PulumiTagMarker
public class FirewallRuleArgsBuilder internal constructor() {
    private var cacheName: Output<String>? = null

    private var endIP: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var startIP: Output<String>? = null

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("mncmsjumplkblslr")
    public suspend fun cacheName(`value`: Output<String>) {
        this.cacheName = value
    }

    /**
     * @param value highest IP address included in the range
     */
    @JvmName("hfvxqnarhcryoowv")
    public suspend fun endIP(`value`: Output<String>) {
        this.endIP = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jdwcnmsdeffvsrgk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("nvcqckjvawwmqais")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value lowest IP address included in the range
     */
    @JvmName("nbwgtdrqudksytle")
    public suspend fun startIP(`value`: Output<String>) {
        this.startIP = value
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("curyllajdwnujoll")
    public suspend fun cacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheName = mapped
    }

    /**
     * @param value highest IP address included in the range
     */
    @JvmName("fhwwbxukcyyoeeqt")
    public suspend fun endIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIP = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pcuehexvieilfmbg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("ygcvumxkrgaipvsy")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value lowest IP address included in the range
     */
    @JvmName("dcfklwwlynniacgy")
    public suspend fun startIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIP = mapped
    }

    internal fun build(): FirewallRuleArgs = FirewallRuleArgs(
        cacheName = cacheName,
        endIP = endIP,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        startIP = startIP,
    )
}
