@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.ClusterPropertiesCustomerManagedKeyEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
 * @property keyEncryptionKeyIdentity All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property keyEncryptionKeyUrl Key encryption key Url, versioned only. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
 */
public data class ClusterPropertiesCustomerManagedKeyEncryptionArgs(
    public val keyEncryptionKeyIdentity: Output<ClusterPropertiesKeyEncryptionKeyIdentityArgs>? =
        null,
    public val keyEncryptionKeyUrl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cache.inputs.ClusterPropertiesCustomerManagedKeyEncryptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.cache.inputs.ClusterPropertiesCustomerManagedKeyEncryptionArgs =
        com.pulumi.azurenative.cache.inputs.ClusterPropertiesCustomerManagedKeyEncryptionArgs.builder()
            .keyEncryptionKeyIdentity(
                keyEncryptionKeyIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .keyEncryptionKeyUrl(keyEncryptionKeyUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPropertiesCustomerManagedKeyEncryptionArgs].
 */
@PulumiTagMarker
public class ClusterPropertiesCustomerManagedKeyEncryptionArgsBuilder internal constructor() {
    private var keyEncryptionKeyIdentity: Output<ClusterPropertiesKeyEncryptionKeyIdentityArgs>? =
        null

    private var keyEncryptionKeyUrl: Output<String>? = null

    /**
     * @param value All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("ckyjkakvaouxujqp")
    public suspend
    fun keyEncryptionKeyIdentity(`value`: Output<ClusterPropertiesKeyEncryptionKeyIdentityArgs>) {
        this.keyEncryptionKeyIdentity = value
    }

    /**
     * @param value Key encryption key Url, versioned only. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
     */
    @JvmName("flcedsoffxrcktoy")
    public suspend fun keyEncryptionKeyUrl(`value`: Output<String>) {
        this.keyEncryptionKeyUrl = value
    }

    /**
     * @param value All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("mhbtihqabwrnysmq")
    public suspend
    fun keyEncryptionKeyIdentity(`value`: ClusterPropertiesKeyEncryptionKeyIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKeyIdentity = mapped
    }

    /**
     * @param argument All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("vlalhukfuipytyxp")
    public suspend
    fun keyEncryptionKeyIdentity(argument: suspend ClusterPropertiesKeyEncryptionKeyIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterPropertiesKeyEncryptionKeyIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKeyIdentity = mapped
    }

    /**
     * @param value Key encryption key Url, versioned only. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
     */
    @JvmName("ojajkureebwdbgae")
    public suspend fun keyEncryptionKeyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKeyUrl = mapped
    }

    internal fun build(): ClusterPropertiesCustomerManagedKeyEncryptionArgs =
        ClusterPropertiesCustomerManagedKeyEncryptionArgs(
            keyEncryptionKeyIdentity = keyEncryptionKeyIdentity,
            keyEncryptionKeyUrl = keyEncryptionKeyUrl,
        )
}
