@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.GetEnterprisePrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the RedisEnterprise cluster.
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEnterprisePrivateEndpointConnectionPlainArgs(
    public val clusterName: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cache.inputs.GetEnterprisePrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cache.inputs.GetEnterprisePrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.cache.inputs.GetEnterprisePrivateEndpointConnectionPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterprisePrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetEnterprisePrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the RedisEnterprise cluster.
     */
    @JvmName("euutrsppabrwiyjx")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("wecycvtqyurqwphd")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wiifblefawhaxerf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEnterprisePrivateEndpointConnectionPlainArgs =
        GetEnterprisePrivateEndpointConnectionPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
