@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.GetLinkedServerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property linkedServerName The name of the linked server.
 * @property name The name of the redis cache.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLinkedServerPlainArgs(
    public val linkedServerName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.GetLinkedServerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.GetLinkedServerPlainArgs =
        com.pulumi.azurenative.cache.inputs.GetLinkedServerPlainArgs.builder()
            .linkedServerName(linkedServerName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinkedServerPlainArgs].
 */
@PulumiTagMarker
public class GetLinkedServerPlainArgsBuilder internal constructor() {
    private var linkedServerName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the linked server.
     */
    @JvmName("aeykbegqdrkxomsk")
    public suspend fun linkedServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkedServerName = mapped
    }

    /**
     * @param value The name of the redis cache.
     */
    @JvmName("pxurjfuaivgctrlr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jvupiphlrbhhwxvo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLinkedServerPlainArgs = GetLinkedServerPlainArgs(
        linkedServerName = linkedServerName ?: throw PulumiNullFieldException("linkedServerName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
