@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.SkuArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.SkuFamily
import com.pulumi.azurenative.cache.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU parameters supplied to the create Redis operation.
 * @property capacity The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
 * @property family The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
 * @property name The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
 */
public data class SkuArgs(
    public val capacity: Output<Int>,
    public val family: Output<Either<String, SkuFamily>>,
    public val name: Output<Either<String, SkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.SkuArgs =
        com.pulumi.azurenative.cache.inputs.SkuArgs.builder()
            .capacity(capacity.applyValue({ args0 -> args0 }))
            .family(
                family.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<Either<String, SkuFamily>>? = null

    private var name: Output<Either<String, SkuName>>? = null

    /**
     * @param value The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
     */
    @JvmName("cxyjeahjslfyqypf")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     */
    @JvmName("qcfauhjkjqqxxbig")
    public suspend fun family(`value`: Output<Either<String, SkuFamily>>) {
        this.family = value
    }

    /**
     * @param value The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
     */
    @JvmName("faujyqgknidiyrpw")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
     */
    @JvmName("qhpvxhimflfuwxno")
    public suspend fun capacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     */
    @JvmName("iifeeavieyylsiju")
    public suspend fun family(`value`: Either<String, SkuFamily>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     */
    @JvmName("dqsrbseofkloogsd")
    public fun family(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     */
    @JvmName("nupgrmqoescpedqg")
    public fun family(`value`: SkuFamily) {
        val toBeMapped = Either.ofRight<String, SkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
     */
    @JvmName("ffixexlxlnxhuqgj")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
     */
    @JvmName("glsjsktacuksbqee")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
     */
    @JvmName("agqnfkmrldcimlin")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity ?: throw PulumiNullFieldException("capacity"),
        family = family ?: throw PulumiNullFieldException("family"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
