@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Optional set of properties to configure geo replication for this database.
 * @property groupNickname Name for the group of linked database resources
 * @property linkedDatabases List of database resources to link with this database
 */
public data class DatabasePropertiesResponseGeoReplication(
    public val groupNickname: String? = null,
    public val linkedDatabases: List<LinkedDatabaseResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.DatabasePropertiesResponseGeoReplication):
            DatabasePropertiesResponseGeoReplication = DatabasePropertiesResponseGeoReplication(
            groupNickname = javaType.groupNickname().map({ args0 -> args0 }).orElse(null),
            linkedDatabases = javaType.linkedDatabases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.LinkedDatabaseResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
