@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SKU parameters supplied to the create RedisEnterprise operation.
 * @property capacity The size of the RedisEnterprise cluster. Defaults to 2 or 3 depending on SKU. Valid values are (2, 4, 6, ...) for Enterprise SKUs and (3, 9, 15, ...) for Flash SKUs.
 * @property name The type of RedisEnterprise cluster to deploy. Possible values: (Enterprise_E10, EnterpriseFlash_F300 etc.)
 */
public data class EnterpriseSkuResponse(
    public val capacity: Int? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.EnterpriseSkuResponse):
            EnterpriseSkuResponse = EnterpriseSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
