@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a database on the RedisEnterprise cluster
 * @property clientProtocol Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
 * @property clusteringPolicy Clustering policy - default is OSSCluster. Specified at create time.
 * @property evictionPolicy Redis eviction policy - default is VolatileLRU
 * @property geoReplication Optional set of properties to configure geo replication for this database.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property modules Optional set of redis modules to enable in this database - modules can only be added at creation time.
 * @property name The name of the resource
 * @property persistence Persistence settings
 * @property port TCP port of the database endpoint. Specified at create time. Defaults to an available port.
 * @property provisioningState Current provisioning status of the database
 * @property resourceState Current resource status of the database
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDatabaseResult(
    public val clientProtocol: String? = null,
    public val clusteringPolicy: String? = null,
    public val evictionPolicy: String? = null,
    public val geoReplication: DatabasePropertiesResponseGeoReplication? = null,
    public val id: String,
    public val modules: List<ModuleResponse>? = null,
    public val name: String,
    public val persistence: PersistenceResponse? = null,
    public val port: Int? = null,
    public val provisioningState: String,
    public val resourceState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.GetDatabaseResult):
            GetDatabaseResult = GetDatabaseResult(
            clientProtocol = javaType.clientProtocol().map({ args0 -> args0 }).orElse(null),
            clusteringPolicy = javaType.clusteringPolicy().map({ args0 -> args0 }).orElse(null),
            evictionPolicy = javaType.evictionPolicy().map({ args0 -> args0 }).orElse(null),
            geoReplication = javaType.geoReplication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.DatabasePropertiesResponseGeoReplication.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            modules = javaType.modules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.ModuleResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            persistence = javaType.persistence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.PersistenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
