@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes the RedisEnterprise cluster
 * @property encryption Encryption-at-rest configuration for the cluster.
 * @property hostName DNS name of the cluster endpoint
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property location The geo-location where the resource lives
 * @property minimumTlsVersion The minimum TLS version for the cluster to support, e.g. '1.2'
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connections associated with the specified RedisEnterprise cluster
 * @property provisioningState Current provisioning status of the cluster
 * @property redisVersion Version of redis the cluster supports, e.g. '6'
 * @property resourceState Current resource status of the cluster
 * @property sku The SKU to create, which affects price, performance, and features.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property zones The Availability Zones where this cluster will be deployed.
 */
public data class GetRedisEnterpriseResult(
    public val encryption: ClusterPropertiesResponseEncryption? = null,
    public val hostName: String,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String,
    public val minimumTlsVersion: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val redisVersion: String,
    public val resourceState: String,
    public val sku: EnterpriseSkuResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.GetRedisEnterpriseResult):
            GetRedisEnterpriseResult = GetRedisEnterpriseResult(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.ClusterPropertiesResponseEncryption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostName = javaType.hostName(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            minimumTlsVersion = javaType.minimumTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            redisVersion = javaType.redisVersion(),
            resourceState = javaType.resourceState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.cache.kotlin.outputs.EnterpriseSkuResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
