@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.CdnFunctions.getAFDCustomDomainPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getAFDEndpointPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getAFDOriginGroupPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getAFDOriginPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getCustomDomainPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getEndpointPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getKeyGroupPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getOriginGroupPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getOriginPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getPolicyPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getProfilePlain
import com.pulumi.azurenative.cdn.CdnFunctions.getProfileSupportedOptimizationTypesPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getRoutePlain
import com.pulumi.azurenative.cdn.CdnFunctions.getRulePlain
import com.pulumi.azurenative.cdn.CdnFunctions.getRuleSetPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getSecretPlain
import com.pulumi.azurenative.cdn.CdnFunctions.getSecurityPolicyPlain
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDCustomDomainPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDCustomDomainPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDEndpointPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDEndpointPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDOriginGroupPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDOriginGroupPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDOriginPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetAFDOriginPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetCustomDomainPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetCustomDomainPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetEndpointPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetEndpointPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetKeyGroupPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetKeyGroupPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetOriginGroupPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetOriginGroupPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetOriginPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetOriginPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetPolicyPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetPolicyPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetProfilePlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetProfilePlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetProfileSupportedOptimizationTypesPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetProfileSupportedOptimizationTypesPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetRoutePlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetRoutePlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetRulePlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetRulePlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetRuleSetPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetRuleSetPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GetSecurityPolicyPlainArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GetSecurityPolicyPlainArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDCustomDomainResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDEndpointResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDOriginGroupResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDOriginResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetCustomDomainResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetEndpointResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetKeyGroupResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetOriginGroupResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetOriginResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetPolicyResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetProfileResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetProfileSupportedOptimizationTypesResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetRouteResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetRuleResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetRuleSetResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetSecretResult
import com.pulumi.azurenative.cdn.kotlin.outputs.GetSecurityPolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDCustomDomainResult.Companion.toKotlin as getAFDCustomDomainResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDEndpointResult.Companion.toKotlin as getAFDEndpointResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDOriginGroupResult.Companion.toKotlin as getAFDOriginGroupResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetAFDOriginResult.Companion.toKotlin as getAFDOriginResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetCustomDomainResult.Companion.toKotlin as getCustomDomainResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetEndpointResult.Companion.toKotlin as getEndpointResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetKeyGroupResult.Companion.toKotlin as getKeyGroupResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetOriginGroupResult.Companion.toKotlin as getOriginGroupResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetOriginResult.Companion.toKotlin as getOriginResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetPolicyResult.Companion.toKotlin as getPolicyResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetProfileResult.Companion.toKotlin as getProfileResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetProfileSupportedOptimizationTypesResult.Companion.toKotlin as getProfileSupportedOptimizationTypesResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetRouteResult.Companion.toKotlin as getRouteResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetRuleResult.Companion.toKotlin as getRuleResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetRuleSetResult.Companion.toKotlin as getRuleSetResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GetSecurityPolicyResult.Companion.toKotlin as getSecurityPolicyResultToKotlin

public object CdnFunctions {
    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
     */
    public suspend fun getAFDCustomDomain(argument: GetAFDCustomDomainPlainArgs):
        GetAFDCustomDomainResult =
        getAFDCustomDomainResultToKotlin(getAFDCustomDomainPlain(argument.toJava()).await())

    /**
     * @see [getAFDCustomDomain].
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
     */
    public suspend fun getAFDCustomDomain(
        customDomainName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetAFDCustomDomainResult {
        val argument = GetAFDCustomDomainPlainArgs(
            customDomainName = customDomainName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getAFDCustomDomainResultToKotlin(getAFDCustomDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getAFDCustomDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetAFDCustomDomainPlainArgs].
     * @return Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
     */
    public suspend
    fun getAFDCustomDomain(argument: suspend GetAFDCustomDomainPlainArgsBuilder.() -> Unit):
        GetAFDCustomDomainResult {
        val builder = GetAFDCustomDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAFDCustomDomainResultToKotlin(getAFDCustomDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing AzureFrontDoor endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2020-09-01, 2023-07-01-preview.
     * @param argument null
     * @return Azure Front Door endpoint is the entity within a Azure Front Door profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format <endpointname>.azureedge.net.
     */
    public suspend fun getAFDEndpoint(argument: GetAFDEndpointPlainArgs): GetAFDEndpointResult =
        getAFDEndpointResultToKotlin(getAFDEndpointPlain(argument.toJava()).await())

    /**
     * @see [getAFDEndpoint].
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Azure Front Door endpoint is the entity within a Azure Front Door profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format <endpointname>.azureedge.net.
     */
    public suspend fun getAFDEndpoint(
        endpointName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetAFDEndpointResult {
        val argument = GetAFDEndpointPlainArgs(
            endpointName = endpointName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getAFDEndpointResultToKotlin(getAFDEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getAFDEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetAFDEndpointPlainArgs].
     * @return Azure Front Door endpoint is the entity within a Azure Front Door profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format <endpointname>.azureedge.net.
     */
    public suspend fun getAFDEndpoint(argument: suspend GetAFDEndpointPlainArgsBuilder.() -> Unit):
        GetAFDEndpointResult {
        val builder = GetAFDEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAFDEndpointResultToKotlin(getAFDEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing origin within an origin group.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return Azure Front Door origin is the source of the content being delivered via Azure Front Door. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
     */
    public suspend fun getAFDOrigin(argument: GetAFDOriginPlainArgs): GetAFDOriginResult =
        getAFDOriginResultToKotlin(getAFDOriginPlain(argument.toJava()).await())

    /**
     * @see [getAFDOrigin].
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Azure Front Door origin is the source of the content being delivered via Azure Front Door. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
     */
    public suspend fun getAFDOrigin(
        originGroupName: String,
        originName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetAFDOriginResult {
        val argument = GetAFDOriginPlainArgs(
            originGroupName = originGroupName,
            originName = originName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getAFDOriginResultToKotlin(getAFDOriginPlain(argument.toJava()).await())
    }

    /**
     * @see [getAFDOrigin].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetAFDOriginPlainArgs].
     * @return Azure Front Door origin is the source of the content being delivered via Azure Front Door. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
     */
    public suspend fun getAFDOrigin(argument: suspend GetAFDOriginPlainArgsBuilder.() -> Unit):
        GetAFDOriginResult {
        val builder = GetAFDOriginPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAFDOriginResultToKotlin(getAFDOriginPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing origin group within a profile.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2020-09-01, 2023-07-01-preview.
     * @param argument null
     * @return AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from Azure Front Door.
     */
    public suspend fun getAFDOriginGroup(argument: GetAFDOriginGroupPlainArgs):
        GetAFDOriginGroupResult =
        getAFDOriginGroupResultToKotlin(getAFDOriginGroupPlain(argument.toJava()).await())

    /**
     * @see [getAFDOriginGroup].
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from Azure Front Door.
     */
    public suspend fun getAFDOriginGroup(
        originGroupName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetAFDOriginGroupResult {
        val argument = GetAFDOriginGroupPlainArgs(
            originGroupName = originGroupName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getAFDOriginGroupResultToKotlin(getAFDOriginGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getAFDOriginGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetAFDOriginGroupPlainArgs].
     * @return AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from Azure Front Door.
     */
    public suspend
    fun getAFDOriginGroup(argument: suspend GetAFDOriginGroupPlainArgsBuilder.() -> Unit):
        GetAFDOriginGroupResult {
        val builder = GetAFDOriginGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAFDOriginGroupResultToKotlin(getAFDOriginGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing custom domain within an endpoint.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2016-10-02, 2023-07-01-preview.
     * @param argument null
     * @return Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
     */
    public suspend fun getCustomDomain(argument: GetCustomDomainPlainArgs): GetCustomDomainResult =
        getCustomDomainResultToKotlin(getCustomDomainPlain(argument.toJava()).await())

    /**
     * @see [getCustomDomain].
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
     */
    public suspend fun getCustomDomain(
        customDomainName: String,
        endpointName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetCustomDomainResult {
        val argument = GetCustomDomainPlainArgs(
            customDomainName = customDomainName,
            endpointName = endpointName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getCustomDomainResultToKotlin(getCustomDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetCustomDomainPlainArgs].
     * @return Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
     */
    public suspend fun getCustomDomain(argument: suspend GetCustomDomainPlainArgsBuilder.() -> Unit):
        GetCustomDomainResult {
        val builder = GetCustomDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomDomainResultToKotlin(getCustomDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2016-04-02, 2023-07-01-preview.
     * @param argument null
     * @return CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format <endpointname>.azureedge.net.
     */
    public suspend fun getEndpoint(argument: GetEndpointPlainArgs): GetEndpointResult =
        getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())

    /**
     * @see [getEndpoint].
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format <endpointname>.azureedge.net.
     */
    public suspend fun getEndpoint(
        endpointName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetEndpointResult {
        val argument = GetEndpointPlainArgs(
            endpointName = endpointName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetEndpointPlainArgs].
     * @return CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format <endpointname>.azureedge.net.
     */
    public suspend fun getEndpoint(argument: suspend GetEndpointPlainArgsBuilder.() -> Unit):
        GetEndpointResult {
        val builder = GetEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointResultToKotlin(getEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing KeyGroup within a profile.
     * Azure REST API version: 2023-07-01-preview.
     * @param argument null
     * @return Contains a list of references of UrlSigningKey type secret objects.
     */
    public suspend fun getKeyGroup(argument: GetKeyGroupPlainArgs): GetKeyGroupResult =
        getKeyGroupResultToKotlin(getKeyGroupPlain(argument.toJava()).await())

    /**
     * @see [getKeyGroup].
     * @param keyGroupName Name of the KeyGroup under the profile.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Contains a list of references of UrlSigningKey type secret objects.
     */
    public suspend fun getKeyGroup(
        keyGroupName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetKeyGroupResult {
        val argument = GetKeyGroupPlainArgs(
            keyGroupName = keyGroupName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getKeyGroupResultToKotlin(getKeyGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetKeyGroupPlainArgs].
     * @return Contains a list of references of UrlSigningKey type secret objects.
     */
    public suspend fun getKeyGroup(argument: suspend GetKeyGroupPlainArgsBuilder.() -> Unit):
        GetKeyGroupResult {
        val builder = GetKeyGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyGroupResultToKotlin(getKeyGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing origin within an endpoint.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
     */
    public suspend fun getOrigin(argument: GetOriginPlainArgs): GetOriginResult =
        getOriginResultToKotlin(getOriginPlain(argument.toJava()).await())

    /**
     * @see [getOrigin].
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originName Name of the origin which is unique within the endpoint.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
     */
    public suspend fun getOrigin(
        endpointName: String,
        originName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetOriginResult {
        val argument = GetOriginPlainArgs(
            endpointName = endpointName,
            originName = originName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getOriginResultToKotlin(getOriginPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrigin].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetOriginPlainArgs].
     * @return CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
     */
    public suspend fun getOrigin(argument: suspend GetOriginPlainArgsBuilder.() -> Unit):
        GetOriginResult {
        val builder = GetOriginPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginResultToKotlin(getOriginPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing origin group within an endpoint.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.
     */
    public suspend fun getOriginGroup(argument: GetOriginGroupPlainArgs): GetOriginGroupResult =
        getOriginGroupResultToKotlin(getOriginGroupPlain(argument.toJava()).await())

    /**
     * @see [getOriginGroup].
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.
     */
    public suspend fun getOriginGroup(
        endpointName: String,
        originGroupName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetOriginGroupResult {
        val argument = GetOriginGroupPlainArgs(
            endpointName = endpointName,
            originGroupName = originGroupName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getOriginGroupResultToKotlin(getOriginGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetOriginGroupPlainArgs].
     * @return Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.
     */
    public suspend fun getOriginGroup(argument: suspend GetOriginGroupPlainArgsBuilder.() -> Unit):
        GetOriginGroupResult {
        val builder = GetOriginGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginGroupResultToKotlin(getOriginGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return Defines web application firewall policy for Azure CDN.
     */
    public suspend fun getPolicy(argument: GetPolicyPlainArgs): GetPolicyResult =
        getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPolicy].
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Defines web application firewall policy for Azure CDN.
     */
    public suspend fun getPolicy(policyName: String, resourceGroupName: String): GetPolicyResult {
        val argument = GetPolicyPlainArgs(
            policyName = policyName,
            resourceGroupName = resourceGroupName,
        )
        return getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetPolicyPlainArgs].
     * @return Defines web application firewall policy for Azure CDN.
     */
    public suspend fun getPolicy(argument: suspend GetPolicyPlainArgsBuilder.() -> Unit):
        GetPolicyResult {
        val builder = GetPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyResultToKotlin(getPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an Azure Front Door Standard or Azure Front Door Premium or CDN profile with the specified profile name under the specified subscription and resource group.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2016-04-02, 2020-09-01, 2023-07-01-preview.
     * @param argument null
     * @return A profile is a logical grouping of endpoints that share the same settings.
     */
    public suspend fun getProfile(argument: GetProfilePlainArgs): GetProfileResult =
        getProfileResultToKotlin(getProfilePlain(argument.toJava()).await())

    /**
     * @see [getProfile].
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium or CDN profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return A profile is a logical grouping of endpoints that share the same settings.
     */
    public suspend fun getProfile(profileName: String, resourceGroupName: String): GetProfileResult {
        val argument = GetProfilePlainArgs(
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getProfileResultToKotlin(getProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetProfilePlainArgs].
     * @return A profile is a logical grouping of endpoints that share the same settings.
     */
    public suspend fun getProfile(argument: suspend GetProfilePlainArgsBuilder.() -> Unit):
        GetProfileResult {
        val builder = GetProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProfileResultToKotlin(getProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the supported optimization types for the current profile. A user can create an endpoint with an optimization type from the listed values.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2020-09-01, 2023-07-01-preview.
     * @param argument null
     * @return The result of the GetSupportedOptimizationTypes API
     */
    public suspend
    fun getProfileSupportedOptimizationTypes(argument: GetProfileSupportedOptimizationTypesPlainArgs):
        GetProfileSupportedOptimizationTypesResult =
        getProfileSupportedOptimizationTypesResultToKotlin(getProfileSupportedOptimizationTypesPlain(argument.toJava()).await())

    /**
     * @see [getProfileSupportedOptimizationTypes].
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium or CDN profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return The result of the GetSupportedOptimizationTypes API
     */
    public suspend fun getProfileSupportedOptimizationTypes(
        profileName: String,
        resourceGroupName: String,
    ): GetProfileSupportedOptimizationTypesResult {
        val argument = GetProfileSupportedOptimizationTypesPlainArgs(
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getProfileSupportedOptimizationTypesResultToKotlin(getProfileSupportedOptimizationTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getProfileSupportedOptimizationTypes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetProfileSupportedOptimizationTypesPlainArgs].
     * @return The result of the GetSupportedOptimizationTypes API
     */
    public suspend
    fun getProfileSupportedOptimizationTypes(argument: suspend GetProfileSupportedOptimizationTypesPlainArgsBuilder.() -> Unit):
        GetProfileSupportedOptimizationTypesResult {
        val builder = GetProfileSupportedOptimizationTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProfileSupportedOptimizationTypesResultToKotlin(getProfileSupportedOptimizationTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2020-09-01, 2023-07-01-preview.
     * @param argument null
     * @return Friendly Routes name mapping to the any Routes or secret related information.
     */
    public suspend fun getRoute(argument: GetRoutePlainArgs): GetRouteResult =
        getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())

    /**
     * @see [getRoute].
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param routeName Name of the routing rule.
     * @return Friendly Routes name mapping to the any Routes or secret related information.
     */
    public suspend fun getRoute(
        endpointName: String,
        profileName: String,
        resourceGroupName: String,
        routeName: String,
    ): GetRouteResult {
        val argument = GetRoutePlainArgs(
            endpointName = endpointName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
            routeName = routeName,
        )
        return getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())
    }

    /**
     * @see [getRoute].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetRoutePlainArgs].
     * @return Friendly Routes name mapping to the any Routes or secret related information.
     */
    public suspend fun getRoute(argument: suspend GetRoutePlainArgsBuilder.() -> Unit):
        GetRouteResult {
        val builder = GetRoutePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteResultToKotlin(getRoutePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing delivery rule within a rule set.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return Friendly Rules name mapping to the any Rules or secret related information.
     */
    public suspend fun getRule(argument: GetRulePlainArgs): GetRuleResult =
        getRuleResultToKotlin(getRulePlain(argument.toJava()).await())

    /**
     * @see [getRule].
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleSetName Name of the rule set under the profile.
     * @return Friendly Rules name mapping to the any Rules or secret related information.
     */
    public suspend fun getRule(
        profileName: String,
        resourceGroupName: String,
        ruleName: String,
        ruleSetName: String,
    ): GetRuleResult {
        val argument = GetRulePlainArgs(
            profileName = profileName,
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
            ruleSetName = ruleSetName,
        )
        return getRuleResultToKotlin(getRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetRulePlainArgs].
     * @return Friendly Rules name mapping to the any Rules or secret related information.
     */
    public suspend fun getRule(argument: suspend GetRulePlainArgsBuilder.() -> Unit): GetRuleResult {
        val builder = GetRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRuleResultToKotlin(getRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return Friendly RuleSet name mapping to the any RuleSet or secret related information.
     */
    public suspend fun getRuleSet(argument: GetRuleSetPlainArgs): GetRuleSetResult =
        getRuleSetResultToKotlin(getRuleSetPlain(argument.toJava()).await())

    /**
     * @see [getRuleSet].
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @return Friendly RuleSet name mapping to the any RuleSet or secret related information.
     */
    public suspend fun getRuleSet(
        profileName: String,
        resourceGroupName: String,
        ruleSetName: String,
    ): GetRuleSetResult {
        val argument = GetRuleSetPlainArgs(
            profileName = profileName,
            resourceGroupName = resourceGroupName,
            ruleSetName = ruleSetName,
        )
        return getRuleSetResultToKotlin(getRuleSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getRuleSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetRuleSetPlainArgs].
     * @return Friendly RuleSet name mapping to the any RuleSet or secret related information.
     */
    public suspend fun getRuleSet(argument: suspend GetRuleSetPlainArgsBuilder.() -> Unit):
        GetRuleSetResult {
        val builder = GetRuleSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRuleSetResultToKotlin(getRuleSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing Secret within a profile.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return Friendly Secret name mapping to the any Secret or secret related information.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param secretName Name of the Secret under the profile.
     * @return Friendly Secret name mapping to the any Secret or secret related information.
     */
    public suspend fun getSecret(
        profileName: String,
        resourceGroupName: String,
        secretName: String,
    ): GetSecretResult {
        val argument = GetSecretPlainArgs(
            profileName = profileName,
            resourceGroupName = resourceGroupName,
            secretName = secretName,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return Friendly Secret name mapping to the any Secret or secret related information.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit):
        GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing security policy within a profile.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2023-07-01-preview.
     * @param argument null
     * @return SecurityPolicy association for AzureFrontDoor profile
     */
    public suspend fun getSecurityPolicy(argument: GetSecurityPolicyPlainArgs):
        GetSecurityPolicyResult =
        getSecurityPolicyResultToKotlin(getSecurityPolicyPlain(argument.toJava()).await())

    /**
     * @see [getSecurityPolicy].
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param securityPolicyName Name of the security policy under the profile.
     * @return SecurityPolicy association for AzureFrontDoor profile
     */
    public suspend fun getSecurityPolicy(
        profileName: String,
        resourceGroupName: String,
        securityPolicyName: String,
    ): GetSecurityPolicyResult {
        val argument = GetSecurityPolicyPlainArgs(
            profileName = profileName,
            resourceGroupName = resourceGroupName,
            securityPolicyName = securityPolicyName,
        )
        return getSecurityPolicyResultToKotlin(getSecurityPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cdn&#46;kotlin&#46;inputs&#46;GetSecurityPolicyPlainArgs].
     * @return SecurityPolicy association for AzureFrontDoor profile
     */
    public suspend
    fun getSecurityPolicy(argument: suspend GetSecurityPolicyPlainArgsBuilder.() -> Unit):
        GetSecurityPolicyResult {
        val builder = GetSecurityPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityPolicyResultToKotlin(getSecurityPolicyPlain(builtArgument.toJava()).await())
    }
}
