@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [KeyGroup].
 */
@PulumiTagMarker
public class KeyGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyGroupArgs = KeyGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyGroupArgsBuilder.() -> Unit) {
        val builder = KeyGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KeyGroup {
        val builtJavaResource = com.pulumi.azurenative.cdn.KeyGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyGroup(builtJavaResource)
    }
}

/**
 * Contains a list of references of UrlSigningKey type secret objects.
 * Azure REST API version: 2023-07-01-preview.
 * ## Example Usage
 * ### KeyGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var keyGroup = new AzureNative.Cdn.KeyGroup("keyGroup", new()
 *     {
 *         KeyGroupName = "kg1",
 *         KeyReferences = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret1",
 *             },
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret2",
 *             },
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret3",
 *             },
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewKeyGroup(ctx, "keyGroup", &cdn.KeyGroupArgs{
 * 			KeyGroupName: pulumi.String("kg1"),
 * 			KeyReferences: []cdn.ResourceReferenceArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret1"),
 * 				},
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret2"),
 * 				},
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret3"),
 * 				},
 * 			},
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.KeyGroup;
 * import com.pulumi.azurenative.cdn.KeyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var keyGroup = new KeyGroup("keyGroup", KeyGroupArgs.builder()
 *             .keyGroupName("kg1")
 *             .keyReferences(
 *                 Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret1"),
 *                 Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret2"),
 *                 Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret3"))
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:KeyGroup kg1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/keyGroups/{keyGroupName}
 * ```
 */
public class KeyGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.KeyGroup,
) : KotlinCustomResource(javaResource, KeyGroupMapper) {
    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * Names of UrlSigningKey type secret objects
     */
    public val keyReferences: Output<List<ResourceReferenceResponse>>?
        get() = javaResource.keyReferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        resourceReferenceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KeyGroupMapper : ResourceMapper<KeyGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.KeyGroup::class == javaResource::class

    override fun map(javaResource: Resource): KeyGroup = KeyGroup(
        javaResource as
            com.pulumi.azurenative.cdn.KeyGroup,
    )
}

/**
 * @see [KeyGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyGroup].
 */
public suspend fun keyGroup(name: String, block: suspend KeyGroupResourceBuilder.() -> Unit):
    KeyGroup {
    val builder = KeyGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyGroup(name: String): KeyGroup {
    val builder = KeyGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
