@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.OriginGroupArgs.builder
import com.pulumi.azurenative.cdn.kotlin.inputs.HealthProbeParametersArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.HealthProbeParametersArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.ResponseBasedOriginErrorDetectionParametersArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ResponseBasedOriginErrorDetectionParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### OriginGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var originGroup = new AzureNative.Cdn.OriginGroup("originGroup", new()
 *     {
 *         EndpointName = "endpoint1",
 *         HealthProbeSettings = new AzureNative.Cdn.Inputs.HealthProbeParametersArgs
 *         {
 *             ProbeIntervalInSeconds = 120,
 *             ProbePath = "/health.aspx",
 *             ProbeProtocol = AzureNative.Cdn.ProbeProtocol.Http,
 *             ProbeRequestType = AzureNative.Cdn.HealthProbeRequestType.GET,
 *         },
 *         OriginGroupName = "origingroup1",
 *         Origins = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1",
 *             },
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         ResponseBasedOriginErrorDetectionSettings = new AzureNative.Cdn.Inputs.ResponseBasedOriginErrorDetectionParametersArgs
 *         {
 *             ResponseBasedDetectedErrorTypes = AzureNative.Cdn.ResponseBasedDetectedErrorTypes.TcpErrorsOnly,
 *             ResponseBasedFailoverThresholdPercentage = 10,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewOriginGroup(ctx, "originGroup", &cdn.OriginGroupArgs{
 * 			EndpointName: pulumi.String("endpoint1"),
 * 			HealthProbeSettings: &cdn.HealthProbeParametersArgs{
 * 				ProbeIntervalInSeconds: pulumi.Int(120),
 * 				ProbePath:              pulumi.String("/health.aspx"),
 * 				ProbeProtocol:          cdn.ProbeProtocolHttp,
 * 				ProbeRequestType:       cdn.HealthProbeRequestTypeGET,
 * 			},
 * 			OriginGroupName: pulumi.String("origingroup1"),
 * 			Origins: []cdn.ResourceReferenceArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1"),
 * 				},
 * 			},
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			ResponseBasedOriginErrorDetectionSettings: &cdn.ResponseBasedOriginErrorDetectionParametersArgs{
 * 				ResponseBasedDetectedErrorTypes:          cdn.ResponseBasedDetectedErrorTypesTcpErrorsOnly,
 * 				ResponseBasedFailoverThresholdPercentage: pulumi.Int(10),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.OriginGroup;
 * import com.pulumi.azurenative.cdn.OriginGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var originGroup = new OriginGroup("originGroup", OriginGroupArgs.builder()
 *             .endpointName("endpoint1")
 *             .healthProbeSettings(Map.ofEntries(
 *                 Map.entry("probeIntervalInSeconds", 120),
 *                 Map.entry("probePath", "/health.aspx"),
 *                 Map.entry("probeProtocol", "Http"),
 *                 Map.entry("probeRequestType", "GET")
 *             ))
 *             .originGroupName("origingroup1")
 *             .origins(Map.of("id", "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1"))
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .responseBasedOriginErrorDetectionSettings(Map.ofEntries(
 *                 Map.entry("responseBasedDetectedErrorTypes", "TcpErrorsOnly"),
 *                 Map.entry("responseBasedFailoverThresholdPercentage", 10)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:OriginGroup origingroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}
 * ```
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property healthProbeSettings Health probe settings to the origin that is used to determine the health of the origin.
 * @property originGroupName Name of the origin group which is unique within the endpoint.
 * @property origins The source of the content being delivered via CDN within given origin group.
 * @property profileName Name of the CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property responseBasedOriginErrorDetectionSettings The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
 * @property trafficRestorationTimeToHealedOrNewEndpointsInMinutes Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
 */
public data class OriginGroupArgs(
    public val endpointName: Output<String>? = null,
    public val healthProbeSettings: Output<HealthProbeParametersArgs>? = null,
    public val originGroupName: Output<String>? = null,
    public val origins: Output<List<ResourceReferenceArgs>>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val responseBasedOriginErrorDetectionSettings:
    Output<ResponseBasedOriginErrorDetectionParametersArgs>? = null,
    public val trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.OriginGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.OriginGroupArgs =
        com.pulumi.azurenative.cdn.OriginGroupArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .healthProbeSettings(
                healthProbeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .originGroupName(originGroupName?.applyValue({ args0 -> args0 }))
            .origins(
                origins?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .responseBasedOriginErrorDetectionSettings(
                responseBasedOriginErrorDetectionSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .trafficRestorationTimeToHealedOrNewEndpointsInMinutes(
                trafficRestorationTimeToHealedOrNewEndpointsInMinutes?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [OriginGroupArgs].
 */
@PulumiTagMarker
public class OriginGroupArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var healthProbeSettings: Output<HealthProbeParametersArgs>? = null

    private var originGroupName: Output<String>? = null

    private var origins: Output<List<ResourceReferenceArgs>>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var responseBasedOriginErrorDetectionSettings:
        Output<ResponseBasedOriginErrorDetectionParametersArgs>? = null

    private var trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Output<Int>? = null

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("nqfoosiyptusvcgp")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("jhxbfeauxmguvpqy")
    public suspend fun healthProbeSettings(`value`: Output<HealthProbeParametersArgs>) {
        this.healthProbeSettings = value
    }

    /**
     * @param value Name of the origin group which is unique within the endpoint.
     */
    @JvmName("lmsmrgvyknhgdnuf")
    public suspend fun originGroupName(`value`: Output<String>) {
        this.originGroupName = value
    }

    /**
     * @param value The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("rpcjwtpvbblxutbn")
    public suspend fun origins(`value`: Output<List<ResourceReferenceArgs>>) {
        this.origins = value
    }

    @JvmName("vgmsgcfwrfqujuad")
    public suspend fun origins(vararg values: Output<ResourceReferenceArgs>) {
        this.origins = Output.all(values.asList())
    }

    /**
     * @param values The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("oamjywusglnmphsq")
    public suspend fun origins(values: List<Output<ResourceReferenceArgs>>) {
        this.origins = Output.all(values)
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("bxxqdkmwwgsffkrt")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("aptltivasusyhwnh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
     */
    @JvmName("njsadkitrlnathdd")
    public suspend
    fun responseBasedOriginErrorDetectionSettings(`value`: Output<ResponseBasedOriginErrorDetectionParametersArgs>) {
        this.responseBasedOriginErrorDetectionSettings = value
    }

    /**
     * @param value Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    @JvmName("hjjxadsktpwqesfn")
    public suspend fun trafficRestorationTimeToHealedOrNewEndpointsInMinutes(`value`: Output<Int>) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = value
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("inqxgkomyiujhlhr")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("egpfmssuypbtjvte")
    public suspend fun healthProbeSettings(`value`: HealthProbeParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("dhtetemqvkiysxcg")
    public suspend
    fun healthProbeSettings(argument: suspend HealthProbeParametersArgsBuilder.() -> Unit) {
        val toBeMapped = HealthProbeParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param value Name of the origin group which is unique within the endpoint.
     */
    @JvmName("femuxqvhjlxevwot")
    public suspend fun originGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroupName = mapped
    }

    /**
     * @param value The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("uemiyynjltwdkmit")
    public suspend fun origins(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("fbapsvgnjpoytwyy")
    public suspend fun origins(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("ncbkmthwlnbfmrqk")
    public suspend fun origins(vararg argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("nqbbcaajefhcxfgh")
    public suspend fun origins(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param values The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("jitftxvwniulbnkw")
    public suspend fun origins(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("mrytrrfwkgngepjc")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("sfrolpiuwhujgigb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
     */
    @JvmName("oreivkhlkoqrfbue")
    public suspend
    fun responseBasedOriginErrorDetectionSettings(`value`: ResponseBasedOriginErrorDetectionParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseBasedOriginErrorDetectionSettings = mapped
    }

    /**
     * @param argument The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
     */
    @JvmName("sohjjobwlwkrnvjj")
    public suspend
    fun responseBasedOriginErrorDetectionSettings(argument: suspend ResponseBasedOriginErrorDetectionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseBasedOriginErrorDetectionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.responseBasedOriginErrorDetectionSettings = mapped
    }

    /**
     * @param value Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    @JvmName("orjoblnbvyionmax")
    public suspend fun trafficRestorationTimeToHealedOrNewEndpointsInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = mapped
    }

    internal fun build(): OriginGroupArgs = OriginGroupArgs(
        endpointName = endpointName,
        healthProbeSettings = healthProbeSettings,
        originGroupName = originGroupName,
        origins = origins,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings,
        trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes,
    )
}
