@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.cdn.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Profile].
 */
@PulumiTagMarker
public class ProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfileArgs = ProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfileArgsBuilder.() -> Unit) {
        val builder = ProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Profile {
        val builtJavaResource = com.pulumi.azurenative.cdn.Profile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Profile(builtJavaResource)
    }
}

/**
 * A profile is a logical grouping of endpoints that share the same settings.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-02, 2020-09-01, 2023-07-01-preview.
 * ## Example Usage
 * ### Profiles_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Cdn.Profile("profile", new()
 *     {
 *         Location = "global",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         Sku = new AzureNative.Cdn.Inputs.SkuArgs
 *         {
 *             Name = "Premium_AzureFrontDoor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewProfile(ctx, "profile", &cdn.ProfileArgs{
 * 			Location:          pulumi.String("global"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			Sku: &cdn.SkuArgs{
 * 				Name: pulumi.String("Premium_AzureFrontDoor"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Profile;
 * import com.pulumi.azurenative.cdn.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .location("global")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .sku(Map.of("name", "Premium_AzureFrontDoor"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Profile profile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}
 * ```
 */
public class Profile internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.Profile,
) : KotlinCustomResource(javaResource, ProfileMapper) {
    /**
     * Key-Value pair representing additional properties for profiles.
     */
    public val extendedProperties: Output<Map<String, String>>
        get() = javaResource.extendedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Id of the frontdoor.
     */
    public val frontDoorId: Output<String>
        get() = javaResource.frontDoorId().applyValue({ args0 -> args0 })

    /**
     * Managed service identity (system assigned and/or user assigned identities).
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
     */
    public val originResponseTimeoutSeconds: Output<Int>?
        get() = javaResource.originResponseTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning status of the profile.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource status of the profile.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProfileMapper : ResourceMapper<Profile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.Profile::class == javaResource::class

    override fun map(javaResource: Resource): Profile = Profile(
        javaResource as
            com.pulumi.azurenative.cdn.Profile,
    )
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Profile].
 */
public suspend fun profile(name: String, block: suspend ProfileResourceBuilder.() -> Unit):
    Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun profile(name: String): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
