@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.ProfileArgs.builder
import com.pulumi.azurenative.cdn.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A profile is a logical grouping of endpoints that share the same settings.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-02, 2020-09-01, 2023-07-01-preview.
 * ## Example Usage
 * ### Profiles_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Cdn.Profile("profile", new()
 *     {
 *         Location = "global",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         Sku = new AzureNative.Cdn.Inputs.SkuArgs
 *         {
 *             Name = "Premium_AzureFrontDoor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewProfile(ctx, "profile", &cdn.ProfileArgs{
 * 			Location:          pulumi.String("global"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			Sku: &cdn.SkuArgs{
 * 				Name: pulumi.String("Premium_AzureFrontDoor"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Profile;
 * import com.pulumi.azurenative.cdn.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .location("global")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .sku(Map.of("name", "Premium_AzureFrontDoor"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Profile profile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}
 * ```
 * @property identity Managed service identity (system assigned and/or user assigned identities).
 * @property location Resource location.
 * @property originResponseTimeoutSeconds Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium or CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property sku The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile.
 * @property tags Resource tags.
 */
public data class ProfileArgs(
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val originResponseTimeoutSeconds: Output<Int>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.ProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.ProfileArgs =
        com.pulumi.azurenative.cdn.ProfileArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .originResponseTimeoutSeconds(originResponseTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProfileArgs].
 */
@PulumiTagMarker
public class ProfileArgsBuilder internal constructor() {
    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var originResponseTimeoutSeconds: Output<Int>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities).
     */
    @JvmName("odmgvbmuiirkhnag")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qqnllntoxelslopt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
     */
    @JvmName("ujwgmrlpyeigoxba")
    public suspend fun originResponseTimeoutSeconds(`value`: Output<Int>) {
        this.originResponseTimeoutSeconds = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium or CDN profile which is unique within the resource group.
     */
    @JvmName("gjbwktxdgoioatnh")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("laobjhooxiqqxirr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile.
     */
    @JvmName("roptccuucyncjlld")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yersijlxveqdybim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities).
     */
    @JvmName("xrjhayjnglikiwab")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (system assigned and/or user assigned identities).
     */
    @JvmName("acgakkuyrgkggejc")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xdfnpovxfchsisnt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
     */
    @JvmName("vnvvughyhmatipvv")
    public suspend fun originResponseTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originResponseTimeoutSeconds = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium or CDN profile which is unique within the resource group.
     */
    @JvmName("qqwhlfxktiwhkfan")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("pfiitmbncmhfmfos")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile.
     */
    @JvmName("uaiteemqammpjmvg")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile.
     */
    @JvmName("vwdjkvivwgmwkmjg")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sjjwipkmauwutiab")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("axoiyydwvfadachp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProfileArgs = ProfileArgs(
        identity = identity,
        location = location,
        originResponseTimeoutSeconds = originResponseTimeoutSeconds,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
