@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Rule].
 */
@PulumiTagMarker
public class RuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleArgs = RuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleArgsBuilder.() -> Unit) {
        val builder = RuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Rule {
        val builtJavaResource = com.pulumi.azurenative.cdn.Rule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Rule(builtJavaResource)
    }
}

/**
 * Friendly Rules name mapping to the any Rules or secret related information.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### Rules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.Cdn.Rule("rule", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeliveryRuleResponseHeaderActionArgs
 *             {
 *                 Name = "ModifyResponseHeader",
 *                 Parameters = new AzureNative.Cdn.Inputs.HeaderActionParametersArgs
 *                 {
 *                     HeaderAction = "Overwrite",
 *                     HeaderName = "X-CDN",
 *                     TypeName = "DeliveryRuleHeaderActionParameters",
 *                     Value = "MSFT",
 *                 },
 *             },
 *         },
 *         Conditions = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeliveryRuleRequestMethodConditionArgs
 *             {
 *                 Name = "RequestMethod",
 *                 Parameters = new AzureNative.Cdn.Inputs.RequestMethodMatchConditionParametersArgs
 *                 {
 *                     MatchValues = new[]
 *                     {
 *                         "GET",
 *                     },
 *                     NegateCondition = false,
 *                     Operator = "Equal",
 *                     TypeName = "DeliveryRuleRequestMethodConditionParameters",
 *                 },
 *             },
 *         },
 *         Order = 1,
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         RuleName = "rule1",
 *         RuleSetName = "ruleSet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewRule(ctx, "rule", &cdn.RuleArgs{
 * 			Actions: pulumi.Array{
 * 				cdn.DeliveryRuleResponseHeaderAction{
 * 					Name: "ModifyResponseHeader",
 * 					Parameters: cdn.HeaderActionParameters{
 * 						HeaderAction: "Overwrite",
 * 						HeaderName:   "X-CDN",
 * 						TypeName:     "DeliveryRuleHeaderActionParameters",
 * 						Value:        "MSFT",
 * 					},
 * 				},
 * 			},
 * 			Conditions: pulumi.Array{
 * 				cdn.DeliveryRuleRequestMethodCondition{
 * 					Name: "RequestMethod",
 * 					Parameters: cdn.RequestMethodMatchConditionParameters{
 * 						MatchValues: []string{
 * 							"GET",
 * 						},
 * 						NegateCondition: false,
 * 						Operator:        "Equal",
 * 						TypeName:        "DeliveryRuleRequestMethodConditionParameters",
 * 					},
 * 				},
 * 			},
 * 			Order:             pulumi.Int(1),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			RuleName:          pulumi.String("rule1"),
 * 			RuleSetName:       pulumi.String("ruleSet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Rule;
 * import com.pulumi.azurenative.cdn.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("name", "ModifyResponseHeader"),
 *                 Map.entry("parameters", Map.ofEntries(
 *                     Map.entry("headerAction", "Overwrite"),
 *                     Map.entry("headerName", "X-CDN"),
 *                     Map.entry("typeName", "DeliveryRuleHeaderActionParameters"),
 *                     Map.entry("value", "MSFT")
 *                 ))
 *             ))
 *             .conditions(Map.ofEntries(
 *                 Map.entry("name", "RequestMethod"),
 *                 Map.entry("parameters", Map.ofEntries(
 *                     Map.entry("matchValues", "GET"),
 *                     Map.entry("negateCondition", false),
 *                     Map.entry("operator", "Equal"),
 *                     Map.entry("typeName", "DeliveryRuleRequestMethodConditionParameters")
 *                 ))
 *             ))
 *             .order(1)
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .ruleName("rule1")
 *             .ruleSetName("ruleSet1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Rule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}
 * ```
 */
public class Rule internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.Rule,
) : KotlinCustomResource(javaResource, RuleMapper) {
    /**
     * A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    public val actions: Output<List<Any>>
        get() = javaResource.actions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of conditions that must be matched for the actions to be executed
     */
    public val conditions: Output<List<Any>>?
        get() = javaResource.conditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    public val matchProcessingBehavior: Output<String>?
        get() = javaResource.matchProcessingBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
     */
    public val order: Output<Int>
        get() = javaResource.order().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the rule set containing the rule.
     */
    public val ruleSetName: Output<String>
        get() = javaResource.ruleSetName().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RuleMapper : ResourceMapper<Rule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.Rule::class == javaResource::class

    override fun map(javaResource: Resource): Rule = Rule(
        javaResource as
            com.pulumi.azurenative.cdn.Rule,
    )
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rule].
 */
public suspend fun rule(name: String, block: suspend RuleResourceBuilder.() -> Unit): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rule(name: String): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
