@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RuleSet].
 */
@PulumiTagMarker
public class RuleSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleSetArgs = RuleSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleSetArgsBuilder.() -> Unit) {
        val builder = RuleSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RuleSet {
        val builtJavaResource = com.pulumi.azurenative.cdn.RuleSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RuleSet(builtJavaResource)
    }
}

/**
 * Friendly RuleSet name mapping to the any RuleSet or secret related information.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### RuleSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ruleSet = new AzureNative.Cdn.RuleSet("ruleSet", new()
 *     {
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         RuleSetName = "ruleSet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewRuleSet(ctx, "ruleSet", &cdn.RuleSetArgs{
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			RuleSetName:       pulumi.String("ruleSet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.RuleSet;
 * import com.pulumi.azurenative.cdn.RuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ruleSet = new RuleSet("ruleSet", RuleSetArgs.builder()
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .ruleSetName("ruleSet1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:RuleSet ruleSet1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}
 * ```
 */
public class RuleSet internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.RuleSet,
) : KotlinCustomResource(javaResource, RuleSetMapper) {
    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the profile which holds the rule set.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RuleSetMapper : ResourceMapper<RuleSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.RuleSet::class == javaResource::class

    override fun map(javaResource: Resource): RuleSet = RuleSet(
        javaResource as
            com.pulumi.azurenative.cdn.RuleSet,
    )
}

/**
 * @see [RuleSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RuleSet].
 */
public suspend fun ruleSet(name: String, block: suspend RuleSetResourceBuilder.() -> Unit):
    RuleSet {
    val builder = RuleSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RuleSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ruleSet(name: String): RuleSet {
    val builder = RuleSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
