@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed.
 */
public enum class HttpsRedirect(
    public val javaValue: com.pulumi.azurenative.cdn.enums.HttpsRedirect,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.HttpsRedirect> {
    Enabled(com.pulumi.azurenative.cdn.enums.HttpsRedirect.Enabled),
    Disabled(com.pulumi.azurenative.cdn.enums.HttpsRedirect.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.HttpsRedirect = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.HttpsRedirect): HttpsRedirect =
            HttpsRedirect.values().first { it.javaValue == javaType }
    }
}
