@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of response errors for real user requests for which origin will be deemed unhealthy
 */
public enum class ResponseBasedDetectedErrorTypes(
    public val javaValue: com.pulumi.azurenative.cdn.enums.ResponseBasedDetectedErrorTypes,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.ResponseBasedDetectedErrorTypes> {
    None(com.pulumi.azurenative.cdn.enums.ResponseBasedDetectedErrorTypes.None),
    TcpErrorsOnly(com.pulumi.azurenative.cdn.enums.ResponseBasedDetectedErrorTypes.TcpErrorsOnly),
    TcpAndHttpErrors(com.pulumi.azurenative.cdn.enums.ResponseBasedDetectedErrorTypes.TcpAndHttpErrors),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.ResponseBasedDetectedErrorTypes =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.ResponseBasedDetectedErrorTypes):
            ResponseBasedDetectedErrorTypes =
            ResponseBasedDetectedErrorTypes.values().first { it.javaValue == javaType }
    }
}
