@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CacheKeyQueryStringActionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.QueryStringBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the cache-key query string action.
 * @property queryParameters query parameters to include or exclude (comma separated).
 * @property queryStringBehavior Caching behavior for the requests
 * @property typeName
 */
public data class CacheKeyQueryStringActionParametersArgs(
    public val queryParameters: Output<String>? = null,
    public val queryStringBehavior: Output<Either<String, QueryStringBehavior>>,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CacheKeyQueryStringActionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CacheKeyQueryStringActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.CacheKeyQueryStringActionParametersArgs.builder()
            .queryParameters(queryParameters?.applyValue({ args0 -> args0 }))
            .queryStringBehavior(
                queryStringBehavior.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheKeyQueryStringActionParametersArgs].
 */
@PulumiTagMarker
public class CacheKeyQueryStringActionParametersArgsBuilder internal constructor() {
    private var queryParameters: Output<String>? = null

    private var queryStringBehavior: Output<Either<String, QueryStringBehavior>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("jdmaktjfsqpocxqr")
    public suspend fun queryParameters(`value`: Output<String>) {
        this.queryParameters = value
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("aowejcnhlgwswdmj")
    public suspend fun queryStringBehavior(`value`: Output<Either<String, QueryStringBehavior>>) {
        this.queryStringBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("wikmrmbmihcgogpk")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("pgskkpmxbfhtuiyi")
    public suspend fun queryParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("dabcwosvtfngoely")
    public suspend fun queryStringBehavior(`value`: Either<String, QueryStringBehavior>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringBehavior = mapped
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("orvaswaqthltuhhc")
    public fun queryStringBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, QueryStringBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringBehavior = mapped
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("nsjpxgebfqealepl")
    public fun queryStringBehavior(`value`: QueryStringBehavior) {
        val toBeMapped = Either.ofRight<String, QueryStringBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("mymdjvvccfrndmvs")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): CacheKeyQueryStringActionParametersArgs =
        CacheKeyQueryStringActionParametersArgs(
            queryParameters = queryParameters,
            queryStringBehavior = queryStringBehavior ?: throw PulumiNullFieldException("queryStringBehavior"),
            typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        )
}
