@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CustomRuleArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.ActionType
import com.pulumi.azurenative.cdn.kotlin.enums.CustomRuleEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the common attributes for a custom rule that can be included in a waf policy
 * @property action Describes what action to be applied when rule matches
 * @property enabledState Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 * @property matchConditions List of match conditions.
 * @property name Defines the name of the custom rule
 * @property priority Defines in what order this rule be evaluated in the overall list of custom rules
 */
public data class CustomRuleArgs(
    public val action: Output<Either<String, ActionType>>,
    public val enabledState: Output<Either<String, CustomRuleEnabledState>>? = null,
    public val matchConditions: Output<List<MatchConditionArgs>>,
    public val name: Output<String>,
    public val priority: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CustomRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CustomRuleArgs =
        com.pulumi.azurenative.cdn.inputs.CustomRuleArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .matchConditions(
                matchConditions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRuleArgs].
 */
@PulumiTagMarker
public class CustomRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var enabledState: Output<Either<String, CustomRuleEnabledState>>? = null

    private var matchConditions: Output<List<MatchConditionArgs>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("yaevnibvlpsfbapv")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("rtfvbmtktpaxhebr")
    public suspend fun enabledState(`value`: Output<Either<String, CustomRuleEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("stqcdoyhtuhkuvvf")
    public suspend fun matchConditions(`value`: Output<List<MatchConditionArgs>>) {
        this.matchConditions = value
    }

    @JvmName("puxhoxmwxkpnnaop")
    public suspend fun matchConditions(vararg values: Output<MatchConditionArgs>) {
        this.matchConditions = Output.all(values.asList())
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("jlocajrkcefoqiwv")
    public suspend fun matchConditions(values: List<Output<MatchConditionArgs>>) {
        this.matchConditions = Output.all(values)
    }

    /**
     * @param value Defines the name of the custom rule
     */
    @JvmName("kmieqcfalinyovvs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines in what order this rule be evaluated in the overall list of custom rules
     */
    @JvmName("vruxbberksiwgrjl")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("jbbbblxkijutuabh")
    public suspend fun action(`value`: Either<String, ActionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("wfegbsxrchgpwvlu")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes what action to be applied when rule matches
     */
    @JvmName("jemxqkjirawpekum")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("jhaeaxohllwvstaa")
    public suspend fun enabledState(`value`: Either<String, CustomRuleEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("wsorujnxienjmldw")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CustomRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("rxhvvtgmbsrtfjdt")
    public fun enabledState(`value`: CustomRuleEnabledState) {
        val toBeMapped = Either.ofRight<String, CustomRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("igpwwmmefydrveiv")
    public suspend fun matchConditions(`value`: List<MatchConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("yhxmjtrbgnfayrbt")
    public suspend fun matchConditions(argument: List<suspend MatchConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("hbrarsoeeeeurtyo")
    public suspend fun matchConditions(
        vararg
        argument: suspend MatchConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("qqstgosfxdomlcjo")
    public suspend fun matchConditions(argument: suspend MatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MatchConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("nyhhmskdictdtumg")
    public suspend fun matchConditions(vararg values: MatchConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param value Defines the name of the custom rule
     */
    @JvmName("tvmufvdnyjtpwgkn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines in what order this rule be evaluated in the overall list of custom rules
     */
    @JvmName("coxylthokybnxuvm")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): CustomRuleArgs = CustomRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        enabledState = enabledState,
        matchConditions = matchConditions ?: throw PulumiNullFieldException("matchConditions"),
        name = name ?: throw PulumiNullFieldException("name"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
