@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CustomerCertificateParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Customer Certificate used for https
 * @property secretSource Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
 * @property secretVersion Version of the secret to be used
 * @property subjectAlternativeNames The list of SANs.
 * @property type The type of the secret resource.
 * Expected value is 'CustomerCertificate'.
 * @property useLatestVersion Whether to use the latest version for the certificate
 */
public data class CustomerCertificateParametersArgs(
    public val secretSource: Output<ResourceReferenceArgs>,
    public val secretVersion: Output<String>? = null,
    public val subjectAlternativeNames: Output<List<String>>? = null,
    public val type: Output<String>,
    public val useLatestVersion: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CustomerCertificateParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CustomerCertificateParametersArgs =
        com.pulumi.azurenative.cdn.inputs.CustomerCertificateParametersArgs.builder()
            .secretSource(secretSource.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretVersion(secretVersion?.applyValue({ args0 -> args0 }))
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .useLatestVersion(useLatestVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerCertificateParametersArgs].
 */
@PulumiTagMarker
public class CustomerCertificateParametersArgsBuilder internal constructor() {
    private var secretSource: Output<ResourceReferenceArgs>? = null

    private var secretVersion: Output<String>? = null

    private var subjectAlternativeNames: Output<List<String>>? = null

    private var type: Output<String>? = null

    private var useLatestVersion: Output<Boolean>? = null

    /**
     * @param value Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
     */
    @JvmName("xvtecjebkqdilntt")
    public suspend fun secretSource(`value`: Output<ResourceReferenceArgs>) {
        this.secretSource = value
    }

    /**
     * @param value Version of the secret to be used
     */
    @JvmName("qfyjnqbgvbaucgwi")
    public suspend fun secretVersion(`value`: Output<String>) {
        this.secretVersion = value
    }

    /**
     * @param value The list of SANs.
     */
    @JvmName("nqqrgloqalepuxgl")
    public suspend fun subjectAlternativeNames(`value`: Output<List<String>>) {
        this.subjectAlternativeNames = value
    }

    @JvmName("vqvltorcpallsafc")
    public suspend fun subjectAlternativeNames(vararg values: Output<String>) {
        this.subjectAlternativeNames = Output.all(values.asList())
    }

    /**
     * @param values The list of SANs.
     */
    @JvmName("onwjkfrofwyfwbpg")
    public suspend fun subjectAlternativeNames(values: List<Output<String>>) {
        this.subjectAlternativeNames = Output.all(values)
    }

    /**
     * @param value The type of the secret resource.
     * Expected value is 'CustomerCertificate'.
     */
    @JvmName("ttdndeeftsylgyei")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Whether to use the latest version for the certificate
     */
    @JvmName("qqdvllpvvpysgxse")
    public suspend fun useLatestVersion(`value`: Output<Boolean>) {
        this.useLatestVersion = value
    }

    /**
     * @param value Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
     */
    @JvmName("vpqugjqhqiewonpn")
    public suspend fun secretSource(`value`: ResourceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretSource = mapped
    }

    /**
     * @param argument Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
     */
    @JvmName("jtellbgyekipafhi")
    public suspend fun secretSource(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretSource = mapped
    }

    /**
     * @param value Version of the secret to be used
     */
    @JvmName("nossvqsciqkygmue")
    public suspend fun secretVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretVersion = mapped
    }

    /**
     * @param value The list of SANs.
     */
    @JvmName("kpjspicviagtraqm")
    public suspend fun subjectAlternativeNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param values The list of SANs.
     */
    @JvmName("qddaaywynknsgirb")
    public suspend fun subjectAlternativeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value The type of the secret resource.
     * Expected value is 'CustomerCertificate'.
     */
    @JvmName("ptbcmfmjoqgbfcbs")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Whether to use the latest version for the certificate
     */
    @JvmName("fjgddhisxwvtelde")
    public suspend fun useLatestVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLatestVersion = mapped
    }

    internal fun build(): CustomerCertificateParametersArgs = CustomerCertificateParametersArgs(
        secretSource = secretSource ?: throw PulumiNullFieldException("secretSource"),
        secretVersion = secretVersion,
        subjectAlternativeNames = subjectAlternativeNames,
        type = type ?: throw PulumiNullFieldException("type"),
        useLatestVersion = useLatestVersion,
    )
}
