@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheKeyQueryStringActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the cache-key query string action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'CacheKeyQueryString'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleCacheKeyQueryStringActionArgs(
    public val name: Output<String>,
    public val parameters: Output<CacheKeyQueryStringActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheKeyQueryStringActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheKeyQueryStringActionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheKeyQueryStringActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleCacheKeyQueryStringActionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleCacheKeyQueryStringActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<CacheKeyQueryStringActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'CacheKeyQueryString'.
     */
    @JvmName("ldusrtduuasgdcdt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("kmruhschlpfmlmja")
    public suspend fun parameters(`value`: Output<CacheKeyQueryStringActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'CacheKeyQueryString'.
     */
    @JvmName("afayywhpkoewmacd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("uhigrdmoxomnljfo")
    public suspend fun parameters(`value`: CacheKeyQueryStringActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("minonvdrsfjelpgj")
    public suspend
    fun parameters(argument: suspend CacheKeyQueryStringActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = CacheKeyQueryStringActionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleCacheKeyQueryStringActionArgs =
        DeliveryRuleCacheKeyQueryStringActionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
