@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleIsDeviceConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the IsDevice condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'IsDevice'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleIsDeviceConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<IsDeviceMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleIsDeviceConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleIsDeviceConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleIsDeviceConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleIsDeviceConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleIsDeviceConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<IsDeviceMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'IsDevice'.
     */
    @JvmName("bxoupcdkdffcrrfr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("oxoutpvqwvvnthcq")
    public suspend fun parameters(`value`: Output<IsDeviceMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'IsDevice'.
     */
    @JvmName("tyupfldqavtqqows")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("lrodwppxiyhoqpfk")
    public suspend fun parameters(`value`: IsDeviceMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("evcmxllxwlejqlvb")
    public suspend
    fun parameters(argument: suspend IsDeviceMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = IsDeviceMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleIsDeviceConditionArgs = DeliveryRuleIsDeviceConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
