@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRemoteAddressConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the RemoteAddress condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RemoteAddress'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRemoteAddressConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<RemoteAddressMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRemoteAddressConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleRemoteAddressConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRemoteAddressConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRemoteAddressConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRemoteAddressConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<RemoteAddressMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RemoteAddress'.
     */
    @JvmName("sivgeilvybagknew")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("yxlatlhvrgosrrtq")
    public suspend fun parameters(`value`: Output<RemoteAddressMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RemoteAddress'.
     */
    @JvmName("veqsownhrupjyphc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("anrgeflvkwihvntb")
    public suspend fun parameters(`value`: RemoteAddressMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("mybhjgecklavkiiu")
    public suspend
    fun parameters(argument: suspend RemoteAddressMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RemoteAddressMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRemoteAddressConditionArgs =
        DeliveryRuleRemoteAddressConditionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
