@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRouteConfigurationOverrideActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the route configuration override action for the delivery rule. Only applicable to Frontdoor Standard/Premium Profiles.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'RouteConfigurationOverride'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleRouteConfigurationOverrideActionArgs(
    public val name: Output<String>,
    public val parameters: Output<RouteConfigurationOverrideActionParametersArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRouteConfigurationOverrideActionArgs> {
    override fun toJava():
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRouteConfigurationOverrideActionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRouteConfigurationOverrideActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRouteConfigurationOverrideActionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRouteConfigurationOverrideActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<RouteConfigurationOverrideActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'RouteConfigurationOverride'.
     */
    @JvmName("wgntrxntjqqopxmt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("sbesdwlpitnyotll")
    public suspend fun parameters(`value`: Output<RouteConfigurationOverrideActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'RouteConfigurationOverride'.
     */
    @JvmName("juooqeyqktsuuvuq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("vofukiawyxfnabcv")
    public suspend fun parameters(`value`: RouteConfigurationOverrideActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("ugjdimmbvttasxyf")
    public suspend
    fun parameters(argument: suspend RouteConfigurationOverrideActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RouteConfigurationOverrideActionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRouteConfigurationOverrideActionArgs =
        DeliveryRuleRouteConfigurationOverrideActionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
