@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileNameConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the UrlFileName condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'UrlFileName'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleUrlFileNameConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<UrlFileNameMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileNameConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileNameConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlFileNameConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleUrlFileNameConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleUrlFileNameConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<UrlFileNameMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'UrlFileName'.
     */
    @JvmName("gnkycwbbtjvcixfs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("jougxvcdtwjqtjng")
    public suspend fun parameters(`value`: Output<UrlFileNameMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'UrlFileName'.
     */
    @JvmName("jmtqbfvfhgxlenft")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("dxdhqepudlryiqmn")
    public suspend fun parameters(`value`: UrlFileNameMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("wsbrkgrvcaddsons")
    public suspend
    fun parameters(argument: suspend UrlFileNameMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = UrlFileNameMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleUrlFileNameConditionArgs = DeliveryRuleUrlFileNameConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
