@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A policy that specifies the delivery rules to be used for an endpoint.
 * @property description User-friendly description of the policy.
 * @property rules A list of the delivery rules.
 */
public data class EndpointPropertiesUpdateParametersDeliveryPolicyArgs(
    public val description: Output<String>? = null,
    public val rules: Output<List<DeliveryRuleArgs>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs =
        com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointPropertiesUpdateParametersDeliveryPolicyArgs].
 */
@PulumiTagMarker
public class EndpointPropertiesUpdateParametersDeliveryPolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var rules: Output<List<DeliveryRuleArgs>>? = null

    /**
     * @param value User-friendly description of the policy.
     */
    @JvmName("fsafbxevsryogjjh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of the delivery rules.
     */
    @JvmName("kqphhvvjjqxlntiq")
    public suspend fun rules(`value`: Output<List<DeliveryRuleArgs>>) {
        this.rules = value
    }

    @JvmName("krmlpthtcuaowtml")
    public suspend fun rules(vararg values: Output<DeliveryRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values A list of the delivery rules.
     */
    @JvmName("gkhpmqducahkrmdy")
    public suspend fun rules(values: List<Output<DeliveryRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value User-friendly description of the policy.
     */
    @JvmName("ubafibncrjnbirto")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of the delivery rules.
     */
    @JvmName("ubdyxonsbiidpryk")
    public suspend fun rules(`value`: List<DeliveryRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument A list of the delivery rules.
     */
    @JvmName("mmxjqarnnoxtcvdq")
    public suspend fun rules(argument: List<suspend DeliveryRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeliveryRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A list of the delivery rules.
     */
    @JvmName("awtwuaphkuqksmae")
    public suspend fun rules(vararg argument: suspend DeliveryRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeliveryRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A list of the delivery rules.
     */
    @JvmName("rbmsbgfjwntdgsae")
    public suspend fun rules(argument: suspend DeliveryRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DeliveryRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values A list of the delivery rules.
     */
    @JvmName("srfqdlbaxudswigb")
    public suspend fun rules(vararg values: DeliveryRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): EndpointPropertiesUpdateParametersDeliveryPolicyArgs =
        EndpointPropertiesUpdateParametersDeliveryPolicyArgs(
            description = description,
            rules = rules ?: throw PulumiNullFieldException("rules"),
        )
}
