@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetAFDCustomDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customDomainName Name of the domain under the profile which is unique globally.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetAFDCustomDomainPlainArgs(
    public val customDomainName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetAFDCustomDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetAFDCustomDomainPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetAFDCustomDomainPlainArgs.builder()
            .customDomainName(customDomainName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAFDCustomDomainPlainArgs].
 */
@PulumiTagMarker
public class GetAFDCustomDomainPlainArgsBuilder internal constructor() {
    private var customDomainName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the domain under the profile which is unique globally.
     */
    @JvmName("phyvfvqsqugmkfhm")
    public suspend fun customDomainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customDomainName = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("pjdilowdqbrknaet")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("hikjhpolxrgdltlr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAFDCustomDomainPlainArgs = GetAFDCustomDomainPlainArgs(
        customDomainName = customDomainName ?: throw PulumiNullFieldException("customDomainName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
