@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetAFDOriginGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property originGroupName Name of the origin group which is unique within the endpoint.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetAFDOriginGroupPlainArgs(
    public val originGroupName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetAFDOriginGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetAFDOriginGroupPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetAFDOriginGroupPlainArgs.builder()
            .originGroupName(originGroupName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAFDOriginGroupPlainArgs].
 */
@PulumiTagMarker
public class GetAFDOriginGroupPlainArgsBuilder internal constructor() {
    private var originGroupName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the origin group which is unique within the endpoint.
     */
    @JvmName("bnykvmwlhnamjmsr")
    public suspend fun originGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.originGroupName = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("qwoddsjpbcdwkmwm")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("nxuncysbaldtceuw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAFDOriginGroupPlainArgs = GetAFDOriginGroupPlainArgs(
        originGroupName = originGroupName ?: throw PulumiNullFieldException("originGroupName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
