@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetAFDOriginPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property originGroupName Name of the origin group which is unique within the profile.
 * @property originName Name of the origin which is unique within the profile.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetAFDOriginPlainArgs(
    public val originGroupName: String,
    public val originName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetAFDOriginPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetAFDOriginPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetAFDOriginPlainArgs.builder()
            .originGroupName(originGroupName.let({ args0 -> args0 }))
            .originName(originName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAFDOriginPlainArgs].
 */
@PulumiTagMarker
public class GetAFDOriginPlainArgsBuilder internal constructor() {
    private var originGroupName: String? = null

    private var originName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the origin group which is unique within the profile.
     */
    @JvmName("wvlnmnvoypkmvjdm")
    public suspend fun originGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.originGroupName = mapped
    }

    /**
     * @param value Name of the origin which is unique within the profile.
     */
    @JvmName("ankdyetryrtdfrfg")
    public suspend fun originName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.originName = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("xtktoyebxqawqibq")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("lnavqewwuceuoqgi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAFDOriginPlainArgs = GetAFDOriginPlainArgs(
        originGroupName = originGroupName ?: throw PulumiNullFieldException("originGroupName"),
        originName = originName ?: throw PulumiNullFieldException("originName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
