@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetKeyGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyGroupName Name of the KeyGroup under the profile.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetKeyGroupPlainArgs(
    public val keyGroupName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetKeyGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetKeyGroupPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetKeyGroupPlainArgs.builder()
            .keyGroupName(keyGroupName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeyGroupPlainArgs].
 */
@PulumiTagMarker
public class GetKeyGroupPlainArgsBuilder internal constructor() {
    private var keyGroupName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the KeyGroup under the profile.
     */
    @JvmName("dpeceohhckoqrihl")
    public suspend fun keyGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyGroupName = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the resource group.
     */
    @JvmName("qgslnsxedbgapsfy")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("nscgsabkgliituap")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetKeyGroupPlainArgs = GetKeyGroupPlainArgs(
        keyGroupName = keyGroupName ?: throw PulumiNullFieldException("keyGroupName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
