@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the origin group override action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'OriginGroupOverride'.
 * @property parameters Defines the parameters for the action.
 */
public data class OriginGroupOverrideActionArgs(
    public val name: Output<String>,
    public val parameters: Output<OriginGroupOverrideActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionArgs =
        com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OriginGroupOverrideActionArgs].
 */
@PulumiTagMarker
public class OriginGroupOverrideActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<OriginGroupOverrideActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'OriginGroupOverride'.
     */
    @JvmName("ekmsrwadcekpdcjh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("bjcvwsrwhosjrcrd")
    public suspend fun parameters(`value`: Output<OriginGroupOverrideActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'OriginGroupOverride'.
     */
    @JvmName("dfwdsesstdxaxijg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("pfvgooeqvodqoowg")
    public suspend fun parameters(`value`: OriginGroupOverrideActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("abeyrgtcrtwvsbug")
    public suspend
    fun parameters(argument: suspend OriginGroupOverrideActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = OriginGroupOverrideActionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): OriginGroupOverrideActionArgs = OriginGroupOverrideActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
