@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the origin group override action.
 * @property originGroup defines the OriginGroup that would override the DefaultOriginGroup.
 * @property typeName
 */
public data class OriginGroupOverrideActionParametersArgs(
    public val originGroup: Output<ResourceReferenceArgs>,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideActionParametersArgs.builder()
            .originGroup(originGroup.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OriginGroupOverrideActionParametersArgs].
 */
@PulumiTagMarker
public class OriginGroupOverrideActionParametersArgsBuilder internal constructor() {
    private var originGroup: Output<ResourceReferenceArgs>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value defines the OriginGroup that would override the DefaultOriginGroup.
     */
    @JvmName("yufemhunipxvpejd")
    public suspend fun originGroup(`value`: Output<ResourceReferenceArgs>) {
        this.originGroup = value
    }

    /**
     * @param value
     */
    @JvmName("yscemomokivpxxdy")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value defines the OriginGroup that would override the DefaultOriginGroup.
     */
    @JvmName("xmaactkcveebareb")
    public suspend fun originGroup(`value`: ResourceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originGroup = mapped
    }

    /**
     * @param argument defines the OriginGroup that would override the DefaultOriginGroup.
     */
    @JvmName("ydwiokahwkexviob")
    public suspend fun originGroup(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.originGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("ibxkdmllotnmydnd")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): OriginGroupOverrideActionParametersArgs =
        OriginGroupOverrideActionParametersArgs(
            originGroup = originGroup ?: throw PulumiNullFieldException("originGroup"),
            typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        )
}
