@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.RateLimitRuleListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines contents of rate limit rules
 * @property rules List of rules
 */
public data class RateLimitRuleListArgs(
    public val rules: Output<List<RateLimitRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.RateLimitRuleListArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.RateLimitRuleListArgs =
        com.pulumi.azurenative.cdn.inputs.RateLimitRuleListArgs.builder()
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RateLimitRuleListArgs].
 */
@PulumiTagMarker
public class RateLimitRuleListArgsBuilder internal constructor() {
    private var rules: Output<List<RateLimitRuleArgs>>? = null

    /**
     * @param value List of rules
     */
    @JvmName("ibvswxnfglsdtpkq")
    public suspend fun rules(`value`: Output<List<RateLimitRuleArgs>>) {
        this.rules = value
    }

    @JvmName("bdbnjhrxfdrboubu")
    public suspend fun rules(vararg values: Output<RateLimitRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules
     */
    @JvmName("soustdxcgmruwjtm")
    public suspend fun rules(values: List<Output<RateLimitRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value List of rules
     */
    @JvmName("ufjxymuhswncafec")
    public suspend fun rules(`value`: List<RateLimitRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("aindycvowtfxybac")
    public suspend fun rules(argument: List<suspend RateLimitRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RateLimitRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("oytmjvmeemvfmlyk")
    public suspend fun rules(vararg argument: suspend RateLimitRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RateLimitRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules
     */
    @JvmName("qakuvvvslfjgqxci")
    public suspend fun rules(argument: suspend RateLimitRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RateLimitRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of rules
     */
    @JvmName("unemlwkhspdfwnos")
    public suspend fun rules(vararg values: RateLimitRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): RateLimitRuleListArgs = RateLimitRuleListArgs(
        rules = rules,
    )
}
