@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The json object containing security policy waf parameters
 * @property associations Waf associations
 * @property type The type of the Security policy to create.
 * Expected value is 'WebApplicationFirewall'.
 * @property wafPolicy Resource ID.
 */
public data class SecurityPolicyWebApplicationFirewallParametersArgs(
    public val associations: Output<List<SecurityPolicyWebApplicationFirewallAssociationArgs>>? =
        null,
    public val type: Output<String>,
    public val wafPolicy: Output<ResourceReferenceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallParametersArgs =
        com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallParametersArgs.builder()
            .associations(
                associations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .wafPolicy(wafPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SecurityPolicyWebApplicationFirewallParametersArgs].
 */
@PulumiTagMarker
public class SecurityPolicyWebApplicationFirewallParametersArgsBuilder internal constructor() {
    private var associations: Output<List<SecurityPolicyWebApplicationFirewallAssociationArgs>>? =
        null

    private var type: Output<String>? = null

    private var wafPolicy: Output<ResourceReferenceArgs>? = null

    /**
     * @param value Waf associations
     */
    @JvmName("mggmlsvpadoghcmr")
    public suspend
    fun associations(`value`: Output<List<SecurityPolicyWebApplicationFirewallAssociationArgs>>) {
        this.associations = value
    }

    @JvmName("gmdfgjxqrrwmmqgu")
    public suspend fun associations(
        vararg
        values: Output<SecurityPolicyWebApplicationFirewallAssociationArgs>,
    ) {
        this.associations = Output.all(values.asList())
    }

    /**
     * @param values Waf associations
     */
    @JvmName("psjjnsmnaaxoxtba")
    public suspend
    fun associations(values: List<Output<SecurityPolicyWebApplicationFirewallAssociationArgs>>) {
        this.associations = Output.all(values)
    }

    /**
     * @param value The type of the Security policy to create.
     * Expected value is 'WebApplicationFirewall'.
     */
    @JvmName("xsvqtbvyuyjuttsi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("uqebrtslbjfwmrvn")
    public suspend fun wafPolicy(`value`: Output<ResourceReferenceArgs>) {
        this.wafPolicy = value
    }

    /**
     * @param value Waf associations
     */
    @JvmName("gqkwljudnnvskqrv")
    public suspend
    fun associations(`value`: List<SecurityPolicyWebApplicationFirewallAssociationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associations = mapped
    }

    /**
     * @param argument Waf associations
     */
    @JvmName("wktjkyxjrhlrterc")
    public suspend
    fun associations(argument: List<suspend SecurityPolicyWebApplicationFirewallAssociationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecurityPolicyWebApplicationFirewallAssociationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.associations = mapped
    }

    /**
     * @param argument Waf associations
     */
    @JvmName("tdflrycwkafycglb")
    public suspend fun associations(
        vararg
        argument: suspend SecurityPolicyWebApplicationFirewallAssociationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SecurityPolicyWebApplicationFirewallAssociationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.associations = mapped
    }

    /**
     * @param argument Waf associations
     */
    @JvmName("cnsryushaeryufvk")
    public suspend
    fun associations(argument: suspend SecurityPolicyWebApplicationFirewallAssociationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SecurityPolicyWebApplicationFirewallAssociationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.associations = mapped
    }

    /**
     * @param values Waf associations
     */
    @JvmName("mlqjenfngpxgdknb")
    public suspend fun associations(
        vararg
        values: SecurityPolicyWebApplicationFirewallAssociationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associations = mapped
    }

    /**
     * @param value The type of the Security policy to create.
     * Expected value is 'WebApplicationFirewall'.
     */
    @JvmName("qrhaaaudoijoywuh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wjdrxkatymshvuqf")
    public suspend fun wafPolicy(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wafPolicy = mapped
    }

    /**
     * @param argument Resource ID.
     */
    @JvmName("fsgckorycfdgmtbu")
    public suspend fun wafPolicy(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.wafPolicy = mapped
    }

    internal fun build(): SecurityPolicyWebApplicationFirewallParametersArgs =
        SecurityPolicyWebApplicationFirewallParametersArgs(
            associations = associations,
            type = type ?: throw PulumiNullFieldException("type"),
            wafPolicy = wafPolicy,
        )
}
