@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.SkuArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Standard_Verizon = The SKU name for a Standard Verizon CDN profile.
 * Premium_Verizon = The SKU name for a Premium Verizon CDN profile.
 * Custom_Verizon = The SKU name for a Custom Verizon CDN profile.
 * Standard_Akamai = The SKU name for an Akamai CDN profile.
 * Standard_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using GB based billing model.
 * Standard_Microsoft = The SKU name for a Standard Microsoft CDN profile.
 * Standard_AzureFrontDoor =  The SKU name for an Azure Front Door Standard profile.
 * Premium_AzureFrontDoor = The SKU name for an Azure Front Door Premium profile.
 * Standard_955BandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using 95-5 peak bandwidth billing model.
 * Standard_AvgBandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using monthly average peak bandwidth billing model.
 * StandardPlus_ChinaCdn = The SKU name for a China CDN profile for live-streaming using GB based billing model.
 * StandardPlus_955BandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using 95-5 peak bandwidth billing model.
 * StandardPlus_AvgBandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using monthly average peak bandwidth billing model.
 * @property name Name of the pricing tier.
 */
public data class SkuArgs(
    public val name: Output<Either<String, SkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.SkuArgs =
        com.pulumi.azurenative.cdn.inputs.SkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, SkuName>>? = null

    /**
     * @param value Name of the pricing tier.
     */
    @JvmName("txewdntyyfvyrqli")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value Name of the pricing tier.
     */
    @JvmName("crlhnywfubrpbfrg")
    public suspend fun name(`value`: Either<String, SkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the pricing tier.
     */
    @JvmName("xvjtbqnwfsabdwtq")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the pricing tier.
     */
    @JvmName("gjsijykcutwndkvc")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name,
    )
}
