@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.SslProtocolMatchConditionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.SslProtocol
import com.pulumi.azurenative.cdn.kotlin.enums.SslProtocolOperator
import com.pulumi.azurenative.cdn.kotlin.enums.Transform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the parameters for SslProtocol match conditions
 * @property matchValues The match value for the condition of the delivery rule
 * @property negateCondition Describes if this is negate condition or not
 * @property operator Describes operator to be matched
 * @property transforms List of transforms
 * @property typeName
 */
public data class SslProtocolMatchConditionParametersArgs(
    public val matchValues: Output<List<Either<String, SslProtocol>>>? = null,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, SslProtocolOperator>>,
    public val transforms: Output<List<Either<String, Transform>>>? = null,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.SslProtocolMatchConditionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.SslProtocolMatchConditionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.SslProtocolMatchConditionParametersArgs.builder()
            .matchValues(
                matchValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SslProtocolMatchConditionParametersArgs].
 */
@PulumiTagMarker
public class SslProtocolMatchConditionParametersArgsBuilder internal constructor() {
    private var matchValues: Output<List<Either<String, SslProtocol>>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, SslProtocolOperator>>? = null

    private var transforms: Output<List<Either<String, Transform>>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("kcfpktxjhivafkcy")
    public suspend fun matchValues(`value`: Output<List<Either<String, SslProtocol>>>) {
        this.matchValues = value
    }

    @JvmName("cnvfuxtqpawnjgdo")
    public suspend fun matchValues(vararg values: Output<Either<String, SslProtocol>>) {
        this.matchValues = Output.all(values.asList())
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("pajvcdggqgnioxta")
    public suspend fun matchValues(values: List<Output<Either<String, SslProtocol>>>) {
        this.matchValues = Output.all(values)
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("mtgnmpmxitvlchag")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("jshwdqbjqicugwqc")
    public suspend fun `operator`(`value`: Output<Either<String, SslProtocolOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value List of transforms
     */
    @JvmName("myisdsjumpfeessa")
    public suspend fun transforms(`value`: Output<List<Either<String, Transform>>>) {
        this.transforms = value
    }

    @JvmName("pmdnfosqvfbbbwut")
    public suspend fun transforms(vararg values: Output<Either<String, Transform>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms
     */
    @JvmName("ipljysmyytuqdxlg")
    public suspend fun transforms(values: List<Output<Either<String, Transform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("yjskhrsjyjurxgtc")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("hugflyhqeusuxwla")
    public suspend fun matchValues(`value`: List<Either<String, SslProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("ebksoleyjnvntowu")
    public suspend fun matchValues(vararg values: Either<String, SslProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("pwyqtylswefjsxif")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("dhcpqtgtfilcqngg")
    public suspend fun `operator`(`value`: Either<String, SslProtocolOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("kcpkeypawnjxpioc")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslProtocolOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("tjdudflwmrsxonqs")
    public fun `operator`(`value`: SslProtocolOperator) {
        val toBeMapped = Either.ofRight<String, SslProtocolOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value List of transforms
     */
    @JvmName("uaqhrnitpeoywqfv")
    public suspend fun transforms(`value`: List<Either<String, Transform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms
     */
    @JvmName("ulhrrsidswixkgfg")
    public suspend fun transforms(vararg values: Either<String, Transform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param value
     */
    @JvmName("yucckfvnoqommdqy")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): SslProtocolMatchConditionParametersArgs =
        SslProtocolMatchConditionParametersArgs(
            matchValues = matchValues,
            negateCondition = negateCondition,
            `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
            transforms = transforms,
            typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        )
}
