@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlSigningActionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.Algorithm
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the Url Signing action.
 * @property algorithm Algorithm to use for URL signing
 * @property parameterNameOverride Defines which query string parameters in the url to be considered for expires, key id etc.
 * @property typeName
 */
public data class UrlSigningActionParametersArgs(
    public val algorithm: Output<Either<String, Algorithm>>? = null,
    public val parameterNameOverride: Output<List<UrlSigningParamIdentifierArgs>>? = null,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlSigningActionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlSigningActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.UrlSigningActionParametersArgs.builder()
            .algorithm(
                algorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .parameterNameOverride(
                parameterNameOverride?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UrlSigningActionParametersArgs].
 */
@PulumiTagMarker
public class UrlSigningActionParametersArgsBuilder internal constructor() {
    private var algorithm: Output<Either<String, Algorithm>>? = null

    private var parameterNameOverride: Output<List<UrlSigningParamIdentifierArgs>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value Algorithm to use for URL signing
     */
    @JvmName("sphuteqvkgbnijne")
    public suspend fun algorithm(`value`: Output<Either<String, Algorithm>>) {
        this.algorithm = value
    }

    /**
     * @param value Defines which query string parameters in the url to be considered for expires, key id etc.
     */
    @JvmName("akremtunqkrnyoob")
    public suspend fun parameterNameOverride(`value`: Output<List<UrlSigningParamIdentifierArgs>>) {
        this.parameterNameOverride = value
    }

    @JvmName("dojhmmivjjufdsnw")
    public suspend fun parameterNameOverride(vararg values: Output<UrlSigningParamIdentifierArgs>) {
        this.parameterNameOverride = Output.all(values.asList())
    }

    /**
     * @param values Defines which query string parameters in the url to be considered for expires, key id etc.
     */
    @JvmName("vcpswvbagkfkceia")
    public suspend fun parameterNameOverride(values: List<Output<UrlSigningParamIdentifierArgs>>) {
        this.parameterNameOverride = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("veokhfjepsryedvc")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Algorithm to use for URL signing
     */
    @JvmName("qamjsamsfqvqkpeu")
    public suspend fun algorithm(`value`: Either<String, Algorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Algorithm to use for URL signing
     */
    @JvmName("maifxfgorkgipbkw")
    public fun algorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Algorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Algorithm to use for URL signing
     */
    @JvmName("fxnpioflhrvdwjjt")
    public fun algorithm(`value`: Algorithm) {
        val toBeMapped = Either.ofRight<String, Algorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Defines which query string parameters in the url to be considered for expires, key id etc.
     */
    @JvmName("xkcsoaxmieoyfkia")
    public suspend fun parameterNameOverride(`value`: List<UrlSigningParamIdentifierArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterNameOverride = mapped
    }

    /**
     * @param argument Defines which query string parameters in the url to be considered for expires, key id etc.
     */
    @JvmName("fyqntgmqucbhjqrq")
    public suspend
    fun parameterNameOverride(argument: List<suspend UrlSigningParamIdentifierArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UrlSigningParamIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterNameOverride = mapped
    }

    /**
     * @param argument Defines which query string parameters in the url to be considered for expires, key id etc.
     */
    @JvmName("xgeahcculjiagief")
    public suspend fun parameterNameOverride(
        vararg
        argument: suspend UrlSigningParamIdentifierArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            UrlSigningParamIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterNameOverride = mapped
    }

    /**
     * @param argument Defines which query string parameters in the url to be considered for expires, key id etc.
     */
    @JvmName("oxbwagejkxtifjol")
    public suspend
    fun parameterNameOverride(argument: suspend UrlSigningParamIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            UrlSigningParamIdentifierArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameterNameOverride = mapped
    }

    /**
     * @param values Defines which query string parameters in the url to be considered for expires, key id etc.
     */
    @JvmName("djpuouclarsolvxe")
    public suspend fun parameterNameOverride(vararg values: UrlSigningParamIdentifierArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterNameOverride = mapped
    }

    /**
     * @param value
     */
    @JvmName("riqkwydkjhjmpcno")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): UrlSigningActionParametersArgs = UrlSigningActionParametersArgs(
        algorithm = algorithm,
        parameterNameOverride = parameterNameOverride,
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
    )
}
