@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlSigningParamIdentifierArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.ParamIndicator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines how to identify a parameter for a specific purpose e.g. expires
 * @property paramIndicator Indicates the purpose of the parameter
 * @property paramName Parameter name
 */
public data class UrlSigningParamIdentifierArgs(
    public val paramIndicator: Output<Either<String, ParamIndicator>>,
    public val paramName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlSigningParamIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlSigningParamIdentifierArgs =
        com.pulumi.azurenative.cdn.inputs.UrlSigningParamIdentifierArgs.builder()
            .paramIndicator(
                paramIndicator.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .paramName(paramName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UrlSigningParamIdentifierArgs].
 */
@PulumiTagMarker
public class UrlSigningParamIdentifierArgsBuilder internal constructor() {
    private var paramIndicator: Output<Either<String, ParamIndicator>>? = null

    private var paramName: Output<String>? = null

    /**
     * @param value Indicates the purpose of the parameter
     */
    @JvmName("bbhoaighrxcbuovy")
    public suspend fun paramIndicator(`value`: Output<Either<String, ParamIndicator>>) {
        this.paramIndicator = value
    }

    /**
     * @param value Parameter name
     */
    @JvmName("ywoqxgsmljjjhrvm")
    public suspend fun paramName(`value`: Output<String>) {
        this.paramName = value
    }

    /**
     * @param value Indicates the purpose of the parameter
     */
    @JvmName("nabvipuiyvlaogoe")
    public suspend fun paramIndicator(`value`: Either<String, ParamIndicator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramIndicator = mapped
    }

    /**
     * @param value Indicates the purpose of the parameter
     */
    @JvmName("rwsxhxtcxkegdxdi")
    public fun paramIndicator(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ParamIndicator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramIndicator = mapped
    }

    /**
     * @param value Indicates the purpose of the parameter
     */
    @JvmName("yfixastfusrdmcjl")
    public fun paramIndicator(`value`: ParamIndicator) {
        val toBeMapped = Either.ofRight<String, ParamIndicator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramIndicator = mapped
    }

    /**
     * @param value Parameter name
     */
    @JvmName("hwetyppdncvgqmck")
    public suspend fun paramName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramName = mapped
    }

    internal fun build(): UrlSigningParamIdentifierArgs = UrlSigningParamIdentifierArgs(
        paramIndicator = paramIndicator ?: throw PulumiNullFieldException("paramIndicator"),
        paramName = paramName ?: throw PulumiNullFieldException("paramName"),
    )
}
